import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnDestroy,
  OnInit,
  Output,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { AlertHelper } from '@helpers/alert.helper';
import { response } from '@interfaces/response';
import { SurveyModel } from '@models/orders/surveyModel';
import { CommonService } from '@services/common.service';
import { DynamicDialogConfig, DynamicDialogRef } from 'primeng/dynamicdialog';

import { finalize, Subscription } from 'rxjs';
@Component({
  selector: 'survey',
  templateUrl: './survey.component.html',
  styleUrls: ['./survey.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
})
export class SurveyComponent implements OnInit, OnChanges, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _alert: AlertHelper,
    public config: DynamicDialogConfig,
    public ref: DynamicDialogRef
  ) {}
  subscriptions = new Subscription();
  isLoadingSend: boolean;
  surveyModel: SurveyModel = new SurveyModel();
  isFromOrderDetail: boolean = false;
  @Input() orderId: string;
  isShowOrderDetails: boolean;
  applyHideClass: boolean;
  ngOnInit(): void {
    if (this.config.data) {
      this.surveyModel.orderId = this.config.data.surveyData.orderId;
      this.isFromOrderDetail = this.config.data.isFromOrderDetails;
    }
    this.surveyModel.score = 0;
  }
  showAlert: boolean;
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  ngOnChanges() {}

  ngAfterViewInit() {}

  sendSurvey() {
    if (this.surveyModel.score) {
      this.isLoadingSend = true;

      this.cdr.detectChanges();
      this.subscriptions.add(
        this._commonService
          .post(Address.SurveySave, this.surveyModel)
          .pipe(
            finalize(() => {
              this.isLoadingSend = false;
              this.cdr.detectChanges();
            })
          )
          .subscribe(
            (res: response) => {
              this.isLoadingSend = false;
              this.showAlert = true;

              setTimeout(() => {
                this.ref.close(true);
              }, 3000);

              this.cdr.detectChanges();
            },
            (error) => {}
          )
      );
    } else {
      this._alert.warning(' وارد کردن امتیاز و فیلد نظر اجباری است.');
    }
  }

  showOrderDetails() {
    this.isShowOrderDetails = true;
  }

  onRateChange() {
    setTimeout(() => {
      this.applyHideClass = false;
    }, 200);
  }
}
