import {
  CUSTOM_ELEMENTS_SCHEMA,
  NgModule,
  NO_ERRORS_SCHEMA,
  Optional,
  SkipSelf,
} from '@angular/core';
import { SharedModule } from '@shared/SharedModule';

import { SurveyRoutingModule } from './survey.routes';
import { SharedFormsModule } from '@shared/sharedForms.module';

@NgModule({
  declarations: [],
  exports: [SharedModule],
  imports: [SurveyRoutingModule, SharedModule, SharedFormsModule],
  providers: [],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
})
export class SurveyModule {
  constructor(
    @Optional()
    @SkipSelf()
    parentModule: SurveyModule
  ) {
    if (parentModule) {
      throw new Error('SurveyModule is already loaded.');
    }
  }
}
