import { AlertHelper } from '@helpers/alert.helper';
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnChanges,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { Subscription } from 'rxjs';
import { finalize } from 'rxjs/operators';
import { response } from '@interfaces/response';
import { UserStore } from '@stores/user.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { NgForm } from '@angular/forms';
import { PasswordModel } from 'src/app/core/params/auth/password';
import { isStrong } from '@helpers/validator.helper';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { DialogService } from 'primeng/dynamicdialog';
import { ModalChangePasswordComponent } from './changePasswordModal/changePasswordModal.component';
@Component({
  selector: 'app-change-password',
  templateUrl: './change-password.component.html',
  styleUrls: ['./change-password.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class ChangePasswordComponent implements OnInit, OnChanges, OnDestroy {
  public showPassword: boolean;
  public showPasswordOnPress: boolean;
  isLoading: boolean = false;
  subscriptions = new Subscription();
  model: PasswordModel = new PasswordModel();
  @Input() data: UserProfile;
  constructor(
    private _commonService: CommonService,
    private _alert: AlertHelper,
    private _userStore: UserStore,
    private cdr: ChangeDetectorRef,
    public dialogService: DialogService
  ) {}

  ngOnInit(): void {}
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
  ngOnChanges() {}
  userGetInfo() {
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGet, {}, false)
        .pipe(
          finalize(() => {
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.data = response.data;
            this._userStore.user.next(response.data);
            this._userStore.userBehavior.next(response.data);
          },
          (error) => {}
        )
    );
  }

  submit(form: NgForm) {
    if (!isStrong(this.model.password)) {
      this._alert.warning('لطفا یک رمز عبور قوی تر انتخاب نمایید.');
      return;
    }
    this.isLoading = true;
    this.subscriptions.add(
      this._commonService
        .putData(Address.password, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            form.resetForm();
            this.cdr.detectChanges();
          })
        )
        .subscribe((response: response) => {
          this._alert.success('رمز عبور با موفقیت تغییر کرد');
          this.userGetInfo();
        })
    );
  }

  modalChangePassword() {
    const ref = this.dialogService.open(ModalChangePasswordComponent, {
      header: 'دریافت رمز عبور جدید',
      height: '55%',
      width: '33%',
      styleClass: 'resetPassMobile',
      dismissableMask: true,
    });

    ref.onClose.subscribe((model: any) => {});
  }
}
