import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  EventEmitter,
  Input,
  OnDestroy,
  OnInit,
  Output,
} from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { Address } from '@enums/address.enum';
import { MessageStatic } from '@enums/messageStatic.enum';
import { CommonService } from '@services/common.service';
import { Location } from '@angular/common';
import { cloneDeep } from 'lodash-es';
import { Message } from 'primeng/api';
import { DialogService } from 'primeng/dynamicdialog';
import { Subject, Subscription, finalize, takeUntil } from 'rxjs';
import { OrderSearchModel } from 'src/app/core/params/order/OrderSearchModel';
import { BaseParams } from 'src/app/core/params/user/baseParams';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { WalletModelGet } from '@models/user/WalletModelGet';
import { TableLazyLoadEvent } from 'primeng/table';
import { PagingHelper } from '@helpers/paging.helper';
import { CurrencyWalletExchangeComponent } from './currencyWallet-exchange/currencyWalletExchange.component';
import { UserProfile } from '@interfaces/user/userProfile';
import { UserStore } from '@stores/user.store';
import { response } from '@interfaces/response';
import { AlertHelper } from '@helpers/alert.helper';
import { TranslateService } from '@ngx-translate/core';
import { VerifyingModel } from '@models/user/VerifyingModel';
import { WalletSettingModel } from '@models/user/walletSettingModel';
import { ModalContentMobileComponent } from '../../components/modalContentMobile/modalContentMobile.component';
import { CurrencyWalletRechargeComponent } from './currencyWallet-rechage/currencyWallet-recharge.component';
import { ICurrencyWallet } from '@interfaces/user/iCurrencyWallet';
import { ICurrencyWalletBalance } from '@interfaces/user/iCurrencyWalletBalance';
import { ICurrencyWalletTransactions } from '@interfaces/user/iCurrencyWalletTransactions';
import { CurrencyWalletModelGet } from '@models/user/currencyWalletModelGet';

@Component({
  selector: 'currencyWallet',
  templateUrl: './currencyWallet.component.html',
  styleUrls: ['./currencyWallet.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class CurrencyWalletComponent implements OnInit, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    public dialogService: DialogService,
    public _activatedroute: ActivatedRoute,
    public _pagingHelper: PagingHelper,
    public location: Location,
    private _userStore: UserStore,
    private _messageService: AlertHelper,
    private _translateService: TranslateService
  ) {}

  subscriptions = new Subscription();
  isloadingGetWalletSetting: boolean;
  messages: Message[] = [];
  filter: any = {};
  @Input() currencyWallet: CurrencyWalletModelGet = new CurrencyWalletModelGet();
  @Input() totalRecords: number = 0;
  @Output() isVerifiedInfo: EventEmitter<boolean> = new EventEmitter<boolean>();
  isLoading: boolean = false;
  query: BaseParams;
  overlayPanel: boolean;
  search: OrderSearchModel = new OrderSearchModel();
  dataUser: UserProfile = new UserProfile();
  CurrencyWalletId: string;
  walletAmount: number;
  message: string = MessageStatic.NotFound;
  rowsPerPage = this._pagingHelper.rowsPersPage();
  isLoadingActivate: boolean;
  loadingGetInfo: boolean;
  dataVerifying: VerifyingModel[] = [];
  private destroy$ = new Subject<void>();
  isAcceptedMobile: boolean = false;
  hasBankAccount: boolean = false;
  isAcceptedEmail: boolean = false;
  isAcceptedBasicInformation: boolean = false;
  isAcceptedTel: boolean = false;
  isAcceptedSelfie: boolean = false;
  isAcceptedNationalCard: boolean = false;
  isLoadingGetTransactions: boolean = false;
  isLoadingGetBalances: boolean = false;
  dataSettingWallet: WalletSettingModel = new WalletSettingModel();
  styleClass: string = 'verifyingModal';
  width: string = '50%';
  height: string = '95%';
  header: string = 'احراز اطلاعات';
  balances: ICurrencyWalletBalance[] = [];
  transactions: ICurrencyWalletTransactions[] = [];
  walletAddress: ICurrencyWallet | null = null;
  receiveAccounts: any[] = [];
  activeTab = 0;
  displayCurrency = 'EUR';
  totalBalance = 2123.03;
  carouselOptions = {
    loop: false,
    margin: 12,
    nav: true,
    dots: false,
    navText: ['‹', '›'],
    responsive: {
      0: { items: 1.4 },
      480: { items: 2.2 },
      768: { items: 3 },
      1024: { items: 4 },
    },
  };
  currentMobileCurrency = 'EUR';
  mobileMainBalance = 124.0698;
  mobilePager = [0, 1, 2];
  mobilePagerIndex = 0;

  ngOnDestroy(): void {
    this.subscriptions.unsubscribe();
    this.destroy$.next();
    this.destroy$.complete();
  }

  get totalSpent(): number {
    return this.transactions
      .filter((t) => t.amount < 0)
      .reduce((s, t) => s + Math.abs(t.amount), 0);
  }

  ngOnInit(): void {
    this.balances = [
      {
        title: 'پوند',
        code: 'GBP',
        amount: 1230.03,
        iconUrl: 'assets/flags/gb.svg',
        currencyId: '1',
      },
      {
        title: 'یورو',
        code: 'EUR',
        amount: 766.63,
        iconUrl: 'assets/flags/eu.svg',
        currencyId: '2',
      },
      {
        title: 'دلار آمریکا',
        code: 'USD',
        amount: 261.61,
        iconUrl: 'assets/flags/us.svg',
        currencyId: '3',
      },
      {
        title: 'دلار سنگاپور',
        code: 'USD',
        amount: 261.61,
        iconUrl: 'assets/flags/us.svg',
        currencyId: '3',
      },
      {
        title: 'دلار سنگاپور',
        code: 'USD',
        amount: 261.61,
        iconUrl: 'assets/flags/us.svg',
        currencyId: '3',
      },
      {
        title: 'دلار سنگاپور',
        code: 'USD',
        amount: 261.61,
        iconUrl: 'assets/flags/us.svg',
        currencyId: '3',
      },
    ];

    this.transactions = [
      {
        merchant: 'Cineworld',
        saveDate: '2025-11-22T16:55:02.61',
        amount: 39,
        currency: 'GBP',
        walletId: '',
        userId: '',
        amountLimit: 0,
        withdrawalLimitPerMonth: 0,
        changeDate: '',
        currencyTitle: '',
        type: 'out',
      },
      {
        merchant: 'André Pires',
        saveDate: '2025-11-22T16:55:02.61',
        amount: 167.8,
        currency: 'EUR',
        walletId: '',
        userId: '',
        amountLimit: 0,
        withdrawalLimitPerMonth: 0,
        changeDate: '',
        currencyTitle: '',
        type: 'in',
      },
      {
        merchant: 'g2a.com',
        saveDate: '2025-11-22T16:55:02.61',
        amount: 3.31,
        currency: 'EUR',
        walletId: '',
        userId: '',
        amountLimit: 0,
        withdrawalLimitPerMonth: 0,
        changeDate: '',
        currencyTitle: '',
        type: 'out',
      },
    ];

    this.walletAddress = {
      userId: 'ss',
      address: 'DE89 3704 0044 0532 0130 00',
      type: 'IBAN',
    };

    this.receiveAccounts = [
      {
        code: 'GBP',
        name: 'پوند',
        detail: 'GBxx BANK 1234',
        iconUrl: '/assets/flags/gb.png',
      },
      {
        code: 'EUR',
        name: 'یورو',
        detail: 'DExx IBAN',
        iconUrl: '/assets/flags/eu.png',
      },
      {
        code: 'USD',
        name: 'دلار',
        detail: 'USxx IBAN',
        iconUrl: '/assets/flags/us.png',
      },
    ];

    this.totalBalance = this.balances.reduce(
      (sum, b) => sum + (b.amount || 0),
      0
    );
    this.getWalletSetting();
    this.query = new BaseParams();
    this._userStore
      .getUserBehavior()
      .pipe(takeUntil(this.destroy$))
      .subscribe((res) => {
        if (res) {
          this.dataUser = res;
          this.CurrencyWalletId = res.CurrencyWalletId;
          this.walletAmount = Number(res.amountWallet);
        }
        this._userStore
          .getUserVerifyingBehavior()
          .pipe(takeUntil(this.destroy$))
          .subscribe((res) => {
            if (res) {
              this.dataVerifying = res;
              this.checkUserIsVerified();
            }
          });
      });
    // this.getBalances();
    // this.getTransactions();
    // this.getReceiveAccounts();
    this.cdr.detectChanges();
  }

  userGetInfo() {
    this.loadingGetInfo = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .put(Address.UserGet, {}, false)
        .pipe(
          finalize(() => {
            this.loadingGetInfo = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.dataUser = response.data;
            this._userStore.user.next(this.dataUser);
            this._userStore.userBehavior.next(this.dataUser);
            this.CurrencyWalletId = this.dataUser.CurrencyWalletId;
            this.cdr.detectChanges();
          },
          (error) => {}
        )
    );
  }

  goBackToPrevPage() {
    this.location.back();
  }

  activateWallet() {
    this.isLoadingActivate = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .post(Address.WalletCreateByCustomer, {})
        .pipe(
          finalize(() => {
            this.isLoadingActivate = false;
          })
        )
        .subscribe((res) => {
          this.userGetInfo();
          this.cdr.detectChanges();
          this._messageService.success(
            this._translateService.translations[
              this._translateService.currentLang
            ]['yourWalletActivatedSuccessfully']
          );
        })
    );
  }

  getWalletSetting() {
    this.isloadingGetWalletSetting = true;
    this.cdr.detectChanges();
    this.subscriptions.add(
      this._commonService
        .get(Address.GetWalletSetting, {})
        .pipe(
          finalize(() => {
            this.isloadingGetWalletSetting = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.dataSettingWallet = response.data;
            this.cdr.detectChanges();
          },
          (err: any) => {},
          () => {}
        )
    );
  }

  checkUserIsVerified() {
    if (this.dataUser && this.dataVerifying) {
      for (let item of this.dataVerifying) {
        if (
          item.typeVerifying == 111 &&
          item.isAccept &&
          this.dataUser.mobile
        ) {
          this.isAcceptedMobile = true;
        }
        if (item.typeVerifying == 112 && item.isAccept && this.dataUser.email) {
          this.isAcceptedEmail = true;
        }
        if (item.typeVerifying == 113 && item.isAccept && this.dataUser.tel) {
          this.isAcceptedTel = true;
        }
        if (item.typeVerifying == 114 && item.isAccept) {
          this.isAcceptedNationalCard = true;
        }
        if (item.typeVerifying == 115 && item.isAccept) {
          this.hasBankAccount = true;
        }
        if (item.typeVerifying == 116 && item.isAccept) {
          this.isAcceptedSelfie = true;
        }
        if (
          item.typeVerifying == 118 &&
          item.isAccept &&
          this.dataUser.isLockUpdate
        ) {
          this.isAcceptedBasicInformation = true;
        }
      }
    }
  }

  async checkWalletRequirementsBeforeAction(actionCallback: Function) {
    if (!this.dataSettingWallet) {
      await this.getWalletSetting();
    }

    const missingVerifications = [];

    if (
      this.dataSettingWallet.isActiveAuthenticationWalletMobile &&
      !this.isAcceptedMobile
    ) {
      missingVerifications.push('mobile');
    }
    if (
      this.dataSettingWallet.isActiveAuthenticationWalletEmail &&
      !this.isAcceptedEmail
    ) {
      missingVerifications.push('email');
    }
    if (
      this.dataSettingWallet.isActiveAuthenticationWalletTel &&
      !this.isAcceptedTel
    ) {
      missingVerifications.push('tel');
    }
    if (
      this.dataSettingWallet.isActiveAuthenticationWalletNationalCard &&
      !this.isAcceptedNationalCard
    ) {
      missingVerifications.push('nationalCard');
    }
    if (
      this.dataSettingWallet.isActiveAuthenticationWalletSelfiImage &&
      !this.isAcceptedSelfie
    ) {
      missingVerifications.push('selfie');
    }
    if (
      this.dataSettingWallet.isActiveAuthenticationWalletBasicInformation &&
      !this.isAcceptedBasicInformation
    ) {
      missingVerifications.push('basicInfo');
    }
    if (
      this.dataSettingWallet.isActiveAuthenticationWalletBankCard &&
      !this.hasBankAccount
    ) {
      missingVerifications.push('bankCard');
    }

    if (missingVerifications.length === 0) {
      actionCallback();
      return;
    }

    const orderSetting = {
      checkMobile: missingVerifications.includes('mobile'),
      checkEmail: missingVerifications.includes('email'),
      checkPhone: missingVerifications.includes('tel'),
      checkNationalCard: missingVerifications.includes('nationalCard'),
      checkSelfiImage: missingVerifications.includes('selfie'),
      checkBasicInformation: missingVerifications.includes('basicInfo'),
      checkBankAccount: missingVerifications.includes('bankCard'),
    };

    const ref = this.modalGetMobile(orderSetting, missingVerifications);
    ref.onClose.subscribe((verified) => {
      if (verified) {
        this.userGetInfo();
        actionCallback();
        this.isVerifiedInfo.emit(true);
      }
    });
  }

  modalGetMobile(orderSetting, missingFields) {
    const ref = this.dialogService.open(ModalContentMobileComponent, {
      header: this.header,
      height: this.height,
      width: this.width,
      styleClass: this.styleClass,
      data: {
        orderSetting: orderSetting,
        missingFields: missingFields,
      },
      dismissableMask: true,
    });
    return ref;
  }

  getData(event: TableLazyLoadEvent = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    this.query = new BaseParams();
    Object.assign(this.query, this.search);
    this.query = this._pagingHelper.requestParamsSet(event, this.query);
    this.subscriptions.add(
      this._commonService
        .put(Address.TransActionGetAll, { transactionTypeList: '683,684' })
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res) => {
          if (res && res.data) {
            this.currencyWallet = cloneDeep(res.data);
            this.totalRecords = res.actualSize;
            this.cdr.detectChanges();
          }
        })
    );
  }

  walletRecharge() {
    this.checkWalletRequirementsBeforeAction(() => {
      const ref = this.dialogService.open(CurrencyWalletRechargeComponent, {
        header:
          this._translateService.translations[
            this._translateService.currentLang
          ]['walletRecharge'],
        width: '23%',
        styleClass: 'wallet-modal',
        dismissableMask: true,
      });
    });
  }

  cashExchangeWallet() {
    this.checkWalletRequirementsBeforeAction(() => {
      const ref = this.dialogService.open(CurrencyWalletExchangeComponent, {
        header:
          this._translateService.translations[
            this._translateService.currentLang
          ]['walletCash'],
        height: '70%',
        width: '40%',
        styleClass: 'wallet-modal',
        dismissableMask: true,
      });
    });
  }

  getTransactions(event: TableLazyLoadEvent = null): void {
    this.isLoadingGetTransactions = true;
    this.cdr.detectChanges();
    const query = new BaseParams();
    Object.assign(query, this.search || {});
    this._pagingHelper.requestParamsSet(event, query);
    this.subscriptions.add(
      this._commonService
        .put(Address.TransActionGetAll, {
          transactionTypeList: '683,684',
          ...query,
        })
        .pipe(
          finalize(() => {
            this.isLoadingGetTransactions = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res: any) => {
          if (res && res.data) {
            this.transactions = cloneDeep(res.data);
            this.totalRecords = res.actualSize ?? this.transactions.length;
            this.cdr.detectChanges();
          } else {
            this.transactions = [];
            this.totalRecords = 0;
            this.cdr.detectChanges();
          }
        })
    );
  }

  getBalances(event: TableLazyLoadEvent = null): void {
    this.isLoading = true;
    this.cdr.detectChanges();
    const query = new BaseParams();
    Object.assign(query, this.search || {});
    this._pagingHelper.requestParamsSet(event, query);
    this.subscriptions.add(
      this._commonService
        .put(Address.CurrencyWalletBalanceGetAll, { ...query })
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res: any) => {
          if (res && res.data) {
            this.balances = cloneDeep(res.data);
          } else {
            this.balances = [];
          }
          this.cdr.detectChanges();
        })
    );
  }

  getReceiveAccounts(): void {
    this.isLoading = true;
    this.cdr.detectChanges();

    this.subscriptions.add(
      this._commonService
        .put(Address.ReceiveCurrencyWalletAccountsGet, {})
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe((res: any) => {
          if (res && res.data) {
            this.receiveAccounts = cloneDeep(res.data);
          } else {
            this.receiveAccounts = [];
          }
          this.cdr.detectChanges();
        })
    );
  }

  computeTotal() {
    this.totalBalance = this.balances.reduce((s, b) => s + (b.amount || 0), 0);
  }

  onAddMoney(account?: ICurrencyWalletBalance) {
    console.log('Add money', account);
    alert(
      'افزودن پول — این یک نمونه است. متد onAddMoney را به API/دیالوگ متصل کن.'
    );
  }

  onConvert(account?: ICurrencyWalletBalance) {
    console.log('Convert', account);
    alert(
      'تبدیل ارز — این یک نمونه است. متد onConvert را به سرویس تبدیل متصل کن.'
    );
  }

  onWithdraw(account?: ICurrencyWalletBalance) {
    console.log('Withdraw', account);
    alert('برداشت — این یک نمونه است. متد onWithdraw را پیاده‌سازی کن.');
  }
}
