import { AlertHelper } from '@helpers/alert.helper';
import { ChangeDetectionStrategy, ChangeDetectorRef, Component, Input, OnChanges, OnDestroy, OnInit } from '@angular/core';
import { Address } from '@enums/address.enum';
import { CommonService } from '@services/common.service';
import { Subscription } from 'rxjs';
import { finalize, tap } from 'rxjs/operators';
import { response } from '@interfaces/response';
import { UserStore } from '@stores/user.store';
import { UserProfile } from '@interfaces/user/userProfile';
import { NgForm } from '@angular/forms';
import { TwoStepVerificationModel } from 'src/app/core/params/auth/twoStepsVerification';
 
import { fadeAnimation } from 'src/app/core/animations/animations';

@Component({
  selector: 'app-TwoStepVerification',
  templateUrl: './twoStepVerification.component.html',
  styleUrls: ['./twoStepVerification.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' }
})
export class TwoStepVerificationComponent implements OnInit, OnChanges , OnDestroy{
  public showChoice: boolean;
  public showChoiceOnPress: boolean;
  isLoading: boolean = false;
  beActive:boolean;
  subscriptions = new Subscription();
  model: TwoStepVerificationModel = new TwoStepVerificationModel();
  @Input() data: UserProfile;
  constructor(
    private _commonService: CommonService,
    private _alert: AlertHelper,
    private _userStore: UserStore
    , private cdr: ChangeDetectorRef
  ) { }

  ngOnInit(): void {
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }
  ngOnChanges() {
  }
  userGetInfo() {
    this.subscriptions.add(
      this._commonService.put(Address.UserGet, {}, false)
        .pipe(
          finalize(() => {
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response: response) => {
            this.data = response.data;
            this._userStore.user.next(response.data);
            this._userStore.userBehavior.next(response.data);
          },
          (error) => {
          }
        )
    );
  }

  submit(form: NgForm) {
    this.isLoading = true;
    this.subscriptions.add(
      this._commonService.putData(Address.twoStepsVerification, this.model, false)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            form.resetForm();
            this.cdr.detectChanges();
          })
        )
        .subscribe((response: response) => {
          this._alert.success('نحوه ورود به حساب کاربری باموفقیت بروزرسانی شد ');
          this.userGetInfo();
        }
        )
    )
  }
}
