import { AlertHelper } from './../../../core/helpers/alert.helper';
import { CommonService } from '@services/common.service';
import {
  ChangeDetectionStrategy,
  ChangeDetectorRef,
  Component,
  Input,
  OnDestroy,
  OnInit,
} from '@angular/core';
import { Address } from '@enums/address.enum';
import { finalize, Subscription } from 'rxjs';
import { HttpEvent, HttpEventType } from '@angular/common/http';
import { VerifyingModel } from '@models/user/VerifyingModel';
import { response } from '@interfaces/response';
import { FileUploadService } from '@services/fileUpload.service';
import { TranslateService } from '@ngx-translate/core';
import { fadeAnimation } from 'src/app/core/animations/animations';
import { stringIsEmptyOrNull } from '@helpers/validator.helper';

@Component({
  selector: 'uploader-nationalCard',
  templateUrl: 'uploaderNationalCard.component.html',
  styleUrls: ['uploaderNationalCard.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush,
  animations: [fadeAnimation],
  host: { '[@fadeInAnimation]': '' },
})
export class UploaderNationalCardComponent implements OnInit, OnDestroy {
  constructor(
    private _commonService: CommonService,
    private cdr: ChangeDetectorRef,
    private _fileUploadService: FileUploadService,
    private _alert: AlertHelper,
    private translate: TranslateService
  ) { }

  nationalCardAcceptAlert: string = '';
  textError: string = null;
  progress: number = 0;
  subscriptions = new Subscription();
  file: File;
  @Input() id: string = null;
  @Input() extension: string = null;
  extensionStore: string;
  @Input() url: string = null;
  isLoading: boolean = false;
  isLoadingGet: boolean = false;
  canNotUpload: boolean = false;
  @Input() verifyingData: VerifyingModel[] = null;
  isAccept: boolean = false;
  isExists: boolean = false;
  isLoadingSubmit: boolean = false;
  isShowSave: boolean = false;
  messageAlarmTimeToAccept: string;
  async ngOnInit() {
    this.translate.get('waitForNationalCardAlert').subscribe((response) => {
      this.nationalCardAcceptAlert = response;
    });
    this.translate.get('timeForAcceptDocuments').subscribe((response) => {
      this.messageAlarmTimeToAccept = response;
    });
  }
  ngOnDestroy() {
    this.subscriptions.unsubscribe();
  }

  ngOnChanges() {
    if (this.verifyingData != null && this.verifyingData.length > 0) {
      for (let item of this.verifyingData) {
        if (item.typeVerifying == 114) {
          this.isExists = true;
          this.textError = item.text;
          this.isAccept = item.isAccept;
          if (this.isAccept == true && !stringIsEmptyOrNull(this.id)) {
            this.canNotUpload = true;
            this.loadFiles(this.id);
          } else if (
            !this.isAccept &&
            !stringIsEmptyOrNull(item.imageId) &&
            stringIsEmptyOrNull(this.url) &&
            stringIsEmptyOrNull(item.text)
          ) {
            this.canNotUpload = true;
            this.loadFiles(item.imageId);
          }
        }
      }
    }
  }

  fileChange(event) {
    let fileList: FileList =
      event.target != undefined && event.target != null
        ? event.target.files
        : event;
    if (fileList != null && fileList.length > 0) {
      this.file = fileList[0];
      this.fileUpload();
    }
  }

  fileUpload() {
    this.isLoading = true;
    this.subscriptions.add(
      this._fileUploadService
        .fileUpload(this.file.name, this.file, Address.FileUploadBigFileImage)
        .subscribe((event: HttpEvent<any>) => {
          switch (event.type) {
            case HttpEventType.Sent:
              break;
            case HttpEventType.ResponseHeader:
              break;
            case HttpEventType.UploadProgress:
              var eventTotal = event.total ? event.total : 0;
              this.progress = Math.round((event.loaded / eventTotal) * 100);
              this.cdr.detectChanges();
              break;
            case HttpEventType.Response:
              if (event.body['data'] != null) {
                this.id = event.body['data'];

                this.loadFiles(event.body['data']);
                this.isLoading = false;
                this.isShowSave = true;

                this.cdr.detectChanges();
              }
              setTimeout(() => {
                this.progress = 0;
                this.cdr.detectChanges();
              }, 1500);
          }
        })
    );
  }

  addDocument() {
    this.isLoadingSubmit = true;
    this.subscriptions.add(
      this._commonService
        .post(Address.DocumentSave, {
          fileId: this.id,
          documentType: 136,
          title: 'تصویر جلوی کارت ملی',
        })
        .pipe(
          finalize(() => {
            this.isLoadingSubmit = false;
            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.canNotUpload = true;
            this.isShowSave = false;
            this.isExists = true;
            this._alert.success(
              'تصویر جلوی کارت ملی از جانب شما دریافت شده و نتیجه پس از بررسی توسط کارشناسان به شما اطلاع داده خواهد شد'
            );
            this.userGetVerifying();
            this.cdr.detectChanges();
          },
          (err: any) => { },
          () => { }
        )
    );
  }

  loadFiles(id: string) {
    this.isLoadingGet = true;
    this.subscriptions.add(
      this._commonService
        .getResponseText(Address.GetFileUrl + id)
        .pipe(
          finalize(() => {
            this.isLoading = false;
            this.isLoadingGet = false;

            this.cdr.detectChanges();
          })
        )
        .subscribe(
          (response) => {
            this.url = response;
            if (!stringIsEmptyOrNull(this.url)) {
              if(!this.isAccept && !this.canNotUpload){this.autoVerifying(id);this.cdr.detectChanges();}
              this.extensionStore = String(
                this.url.substring(
                  this.url.lastIndexOf('.') + 1,
                  this.url.length
                )
              ).toLowerCase();
            }
            this.cdr.detectChanges();
          },
          (err: any) => { },
          () => { }
        )
    );
  }

  autoVerifying(id: string) {
    this.subscriptions.add(
      this._commonService
        .put(Address.AutoVerifyDocs, { url: this.url, fileId: id })
        .pipe(finalize(() => { }))
        .subscribe(
          (response: response) => {
            if (response.data.isAccept == true && !stringIsEmptyOrNull(response.data.isAccept)) {
              this.isAccept = response.data.isAccept;
            }
            this.cdr.detectChanges();
          },
          (error) => { }
        )
    );
  }

  userGetVerifying() {
    this.subscriptions.add(
      this._commonService
        .put(Address.UserVerifying, {}, false)
        .pipe(finalize(() => { }))
        .subscribe(
          (response: response) => {
            this.verifyingData = response.data;

            this.cdr.detectChanges();
          },
          (error) => { }
        )
    );
  }
}