import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { UserComponent } from './user.component';
import { UserLevelComponent } from './user-level/userLevel.component';
import { AcceptCashExchangeWalletComponent } from './wallet/cash-exchange/accept-cash-exchange/accept.component';
import { UserApplicationsComponent } from './user-applications/userApplications.component';

const routes: Routes = [
  {
    path: '',
    
    component: UserComponent,
    data:{breadcrumb: 'اطلاعات هویتی' },
  },
  {
    path: 'user-level',
    component: UserLevelComponent,
    data:{breadcrumb: 'سطوح کاربری' },
  },
  {
    path: 'accept-cash-exchange-wallet',
    component: AcceptCashExchangeWalletComponent,
  },
  {
    path: 'user-requests',
    component: UserApplicationsComponent,
    data:{breadcrumb: 'درخواست نقد کردن کیف پول' }, 
  }
 
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class UserRoutingModule { }
