import {
  CUSTOM_ELEMENTS_SCHEMA,
  NO_ERRORS_SCHEMA,
  NgModule,
} from '@angular/core';
import { CommonModule } from '@angular/common';
import { UserRoutingModule } from './user-routing.module';
import { UserComponent } from './user.component';
import { SharedModule } from '@shared/SharedModule';
import { ChangePasswordComponent } from './change-password/change-password.component';
import { TwoStepVerificationComponent } from './twoStepVerification/twoStepVerification.component';
import { CountdownModule } from 'ngx-countdown';
import { UserLevelComponent } from './user-level/userLevel.component';
import { WalletComponent } from './wallet/wallet.component';
import { WalletRechargeComponent } from './wallet/wallet-rechage/wallet-recharge.component';
import { CashExchangeWalletComponent } from './wallet/cash-exchange/cashExchange.component';
import { UserApplicationsComponent } from './user-applications/userApplications.component';
import { ModalChangePasswordComponent } from './change-password/changePasswordModal/changePasswordModal.component';
import { CurrencyWalletComponent } from './currencyWallet/currencyWallet.component';
import { CurrencyWalletRechargeComponent } from './currencyWallet/currencyWallet-rechage/currencyWallet-recharge.component';
import { CurrencyWalletExchangeComponent } from './currencyWallet/currencyWallet-exchange/currencyWalletExchange.component';
import { CurrencyWalletTransferComponent } from './currencyWallet/currencyWallet-transfer/currencyWalletTransfer.component';

@NgModule({
  declarations: [
    ChangePasswordComponent,
    TwoStepVerificationComponent,
    UserComponent,
    UserLevelComponent,
    WalletComponent,
    CashExchangeWalletComponent,
    WalletRechargeComponent,
    CurrencyWalletComponent,
    CurrencyWalletRechargeComponent,
    CurrencyWalletExchangeComponent,
    CurrencyWalletTransferComponent,
    UserApplicationsComponent,
    ModalChangePasswordComponent,
  ],
  imports: [CommonModule, UserRoutingModule, SharedModule, CountdownModule],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
  exports: [SharedModule],
})
export class UserModule {}
