import {
  CUSTOM_ELEMENTS_SCHEMA,
  NgModule,
  NO_ERRORS_SCHEMA,
} from '@angular/core';
import { CommonModule } from '@angular/common';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { PrimeModule } from './prime.module';
import { NgxMaskModule } from 'ngx-mask';
import { NgNumberDirective } from '@directives/ngNumber.directive';
import { JalaliDatePipe } from '@pipes/jalaliDate.pipe';
import { PriceTypePipe } from '@pipes/priceType.pipe';
import { StatusOrderComponent } from '@components/statusOrder/statusOrder.component';
import { CharacterTypeDirective } from '@directives/characterType.directive';
import { VerifyingComponent } from '../modules/components/verifying/verifying.component';
import { CarouselModule } from 'ngx-owl-carousel-o';
import { CopyTextDirective } from '@directives/copyText.directive';
import { StatusSupportComponent } from '@components/statusSupport/statusSupport.component';
import { ScrollAnchorDirective } from '@directives/scroll/scrollAnchor.directive';
import { ScrollManagerDirective } from '@directives/scroll/scrollManager.directive';
import { ScrollSectionDirective } from '@directives/scroll/scrollSection.directive';
import { TranslateModule } from '@ngx-translate/core';
import { ImageLoadingComponent } from '@components/imageLoading/imageLoading.component';
import { TrackByPropertyDirective } from '@directives/trackByProperty.directive';
import { PaymentMethodComponent } from '../modules/components/paymentMethod/paymentMethod.component';
import { PaymentGatewayComponent } from '../modules/components/paymentGateway/paymentGateway.component';
import { FactorItemsComponent } from '../modules/components/factorItems/factorItems.component';
import { CardNumberPipe } from '@pipes/cardNumber.pipe';
import { QuestionListComponent } from '../modules/components/questionList/questionList.component';
import { SharpSymbolPipe } from '@pipes/sharpSymbol.pipe';
import { PrintPageComponent } from '../modules/components/printPage/printPage.component';
import { AcceptRolesComponent } from '../modules/components/acceptRoles/acceptRoles.component';
import { InputSwitchModule } from 'primeng/inputswitch';
import { OrderTypePipe } from '@pipes/orderType.pipe';
import { StepWizardComponent } from '../modules/stepWizard/step-wizard-checkout/step-wizard-checkout.component';
import { AlarmForMaximumPriceComponent } from '../modules/components/alarmForMaximumPrice/alarmForMaximumPrice.component';
import { DiscountTypePipe } from '@pipes/discountType.pipe';
import { DiscountInputComponent } from '../modules/components/discount-input/discountInput.component';
import { FilterUSDPipe } from '@pipes/USD-sign-filter.pipe';
import { AcceptCashExchangeWalletComponent } from '../modules/user/wallet/cash-exchange/accept-cash-exchange/accept.component';
import { TutorialModalComponent } from '../modules/components/tutorialModal/tutorialModal.component';
import { ModalContentTutorialComponent } from '../modules/components/tutorialModal/modalContent/modalContent.component';
import { AlarmOrderComponent } from '../modules/components/alarmOrder/alarmOrder.component';
import { OrderGiftcardModalComponent } from '../modules/services/service-giftCards/giftCard/order/orderGiftCardModal/orderGiftCardModal.component';
import { LimitationsComponent } from '../modules/services/components/limitations/limitations.component';
import { CeilOfNumber } from '@pipes/ceilNumber.pipe';
import { CountdownOrderComponent } from '../modules/components/countdownOrder/countdownOrder.component';
import { CountdownModule } from 'ngx-countdown';
import { BlockAccessOrderComponent } from '../modules/components/blockAccessOrder/blockAccessOrder.component';
import { OrderImageIdComponent } from '../modules/components/orderImage/orderImage.component';
import { FloorOfNumber } from '@pipes/floorNumber.pipe';
import { ModalContentMobileComponent } from '../modules/components/modalContentMobile/modalContentMobile.component';
import { MobileVerificationComponent } from '../modules/user/mobile-verification/mobile-verification.component';
import { UpdateProfileComponent } from '../modules/user/update-profile/update-profile.component';
import { EmailVerificationComponent } from '../modules/user/email-verification/email-verification.component';
import { LandlineVerificationComponent } from '../modules/user/landline-verification/landline-verification.component';
import { BankAccountComponent } from '../modules/user/bank-account/bank-account.component';
import { UploaderNationalCardComponent } from '../modules/user/uploader-nationalCard/uploaderNationalCard.component';
import { UploaderSelfiImageComponent } from '../modules/user/uploader-selfiImage/uploaderSelfiImage.component';
import { AddBankAccountComponent } from '../modules/user/bank-account/add-bank-account/addBankAccount.component';
import { DatePickerSelectModule } from '@components/datePickerSelect/datePickerSelect.component';
import { OrderDescriptionComponent } from '../modules/components/orderDescription/orderDescription.component';
import { PublicAlarmComponent } from '../modules/components/publicAlarm/publicAlarm.component';
import { CeilOrFloorOfNumber } from '@pipes/ceilOrFloor.pipe';
import { OrderVerifyComponent } from '../modules/components/modalContentMobile/orderVerify/orderVerify.component';
import { MessageMinAmountComponent } from '../modules/components/modalContentMobile/messageMinAmount/messageMinAmount.component';
import { NotificationAfterSaveComponent } from '../modules/components/notificationAfterSave/notificationAfterSave.component';
import { NotificationBeforeSaveComponent } from '../modules/components/notificationBeforeSave/notificationBeforeSave.component';
import { SurveyComponent } from '../modules/survey/survey.component';
import { CopyWalletDirective } from '@directives/copyWalletValue.directive';
import { QRCodeModule } from 'angularx-qrcode';
import { EmojiDirective } from '@directives/emoji.directive';
import { NumberFormatDirective } from '@directives/formatNumber.directive';
import { TruncateDecimalPipe } from '@pipes/decimal.pipe';
import { TransactionUnitPipe } from '@pipes/transactionUnit.pipe';
import { FactorDetailsComponent } from '../modules/components/factorDetails/factorDetails.component';
import { SubmitCheckoutComponent } from '@components/submitCheckout/submitCheckout.component';
import { CaptchaModule } from '@components/captcha/captcha.component';
import { FactorItemsPlanBComponent } from '../modules/components/factorItems-planB/factorItems.component';
import { DragDropDirective } from '@directives/dragdrop.directive';
import { SelectAddressModalComponent } from '../modules/services/components/selectAddressModal/selectAddressModal.component';
import { EnDigitsPipe } from '@pipes/englishNumbers.pipe';
 
@NgModule({
  declarations: [
    DragDropDirective,
    EmojiDirective,
    CopyTextDirective,
    CopyWalletDirective,
    NgNumberDirective,
    NumberFormatDirective,
    CharacterTypeDirective,
    TrackByPropertyDirective,
    JalaliDatePipe,
    PriceTypePipe,
    OrderTypePipe,
    DiscountTypePipe,
    EnDigitsPipe,
    TruncateDecimalPipe,
    TransactionUnitPipe,
    CeilOfNumber,
    FloorOfNumber,
    SharpSymbolPipe,
    CardNumberPipe,
    FilterUSDPipe,
    CeilOrFloorOfNumber,
    StatusOrderComponent,
    StatusSupportComponent,
    VerifyingComponent,
    AlarmOrderComponent,
    AlarmForMaximumPriceComponent,
    AcceptRolesComponent,
    ScrollAnchorDirective,
    ScrollManagerDirective,
    ScrollSectionDirective,
    DiscountInputComponent,
    ImageLoadingComponent,
    PaymentMethodComponent,
    PaymentGatewayComponent,
    FactorItemsComponent,
    FactorItemsPlanBComponent,
    SubmitCheckoutComponent,
    FactorDetailsComponent,
    QuestionListComponent, 
    PrintPageComponent,
    StepWizardComponent,
    OrderDescriptionComponent,
    PublicAlarmComponent,
    TutorialModalComponent,
    AcceptCashExchangeWalletComponent,
    ModalContentTutorialComponent,
    OrderGiftcardModalComponent,
    LimitationsComponent,
    CountdownOrderComponent,
    BlockAccessOrderComponent,
    OrderImageIdComponent,
    ModalContentMobileComponent,
    SelectAddressModalComponent,
    MobileVerificationComponent,
    UpdateProfileComponent,
    EmailVerificationComponent,
    LandlineVerificationComponent,
    AddBankAccountComponent,
    BankAccountComponent,
    UploaderNationalCardComponent,
    UploaderSelfiImageComponent,
    MessageMinAmountComponent,
    OrderVerifyComponent,
    NotificationAfterSaveComponent,
    NotificationBeforeSaveComponent,

    SurveyComponent,
  ],

  imports: [
    CommonModule,
    PrimeModule,
    NgxMaskModule.forRoot(),
    CarouselModule,
    TranslateModule,
    InputSwitchModule,
    CountdownModule,
    DatePickerSelectModule,
    QRCodeModule,
    CaptchaModule
  ],

  exports: [
    FormsModule,
    PrimeModule,
    ReactiveFormsModule,
    CarouselModule,
    CommonModule,
    CharacterTypeDirective,
    TrackByPropertyDirective,
    NgxMaskModule,
    DragDropDirective,
    EmojiDirective,
    CopyTextDirective,
    CopyWalletDirective,
    NgNumberDirective,
    ScrollAnchorDirective,
    ScrollManagerDirective,
    ScrollSectionDirective,
    NumberFormatDirective,
    JalaliDatePipe,
    CardNumberPipe,
    CeilOrFloorOfNumber,
    PriceTypePipe,
    CeilOfNumber,
    FloorOfNumber,
    DiscountTypePipe,
    EnDigitsPipe,
    TransactionUnitPipe,
    TruncateDecimalPipe,
    SharpSymbolPipe,
    OrderTypePipe,
    FilterUSDPipe,
    StatusOrderComponent,
    StatusSupportComponent,
    VerifyingComponent,
    AlarmOrderComponent, 
    AlarmForMaximumPriceComponent,
    AcceptRolesComponent,
    TranslateModule, 
    ImageLoadingComponent,
    PaymentMethodComponent, 
    PaymentGatewayComponent,
    FactorItemsComponent,
    FactorItemsPlanBComponent,
    SubmitCheckoutComponent,
    FactorDetailsComponent,
    QuestionListComponent,
    PrintPageComponent,
    StepWizardComponent,
    DiscountInputComponent,
    OrderDescriptionComponent,
    TutorialModalComponent,
    AcceptCashExchangeWalletComponent,
    InputSwitchModule,
    ModalContentTutorialComponent,
    OrderGiftcardModalComponent,
    LimitationsComponent,
    CountdownOrderComponent,
    BlockAccessOrderComponent,
    OrderImageIdComponent,
    ModalContentMobileComponent,
    SelectAddressModalComponent,
    MobileVerificationComponent,
    UpdateProfileComponent,
    EmailVerificationComponent,
    LandlineVerificationComponent,
    AddBankAccountComponent,
    BankAccountComponent,
    UploaderNationalCardComponent,
    UploaderSelfiImageComponent,
    PublicAlarmComponent,
    OrderVerifyComponent,
    MessageMinAmountComponent,
    NotificationAfterSaveComponent,
    NotificationBeforeSaveComponent,
    SurveyComponent,
    QRCodeModule,
    CaptchaModule
  ],
  providers: [],
  schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
})
export class SharedModule {}
