import {
    CUSTOM_ELEMENTS_SCHEMA,
    NgModule,
    NO_ERRORS_SCHEMA,
  } from '@angular/core';
  import { HttpClient } from '@angular/common/http';
  import { TranslateHttpLoader } from '@ngx-translate/http-loader';
  import { TranslateLoader, TranslateModule, TranslateService } from '@ngx-translate/core';

  

  @NgModule({
    declarations: [
    ],
    imports: [
      TranslateModule.forRoot({
        loader: {
          provide: TranslateLoader,
          useFactory: (httpTranslateLoader),
          deps: [HttpClient]
        }
      })],
    exports: [
      TranslateModule
    ],
    schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
  })

  export class AppTranslateModule {
    constructor(
      private translate: TranslateService) {
      this.translate.addLangs(['en', 'fa']);
      this.translate.setDefaultLang('fa');
      

    }

    
  }


  export function httpTranslateLoader(http: HttpClient) {
    return new TranslateHttpLoader(http, './assets/i18n/', '.json');
  }