﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.ActionLog;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.IDatabase.ICrm;
using Farakonesh.Models.Database.StoredProcedures.App.Crm;

namespace Farakonesh.API.Controllers.App.Crm
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CallHistoryController : ControllerBase
    {
        private readonly ICallHistoryContext _ctx;
        public CallHistoryController(
        ICallHistoryContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست سابقه ی تماس سی آر ام - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_CallHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_CallHistory(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سابقه ی تماس سی آر ام - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_CallHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CallHistory(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سابقه ی تماس سی آر ام گروهی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveGroup([FromBody] Insert_CallHistoryGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CallHistoryGroup(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف سابقه ی تماس سی آر ام - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_CallHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_CallHistory(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
