﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Currency;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Cryptocurrency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CryptoCurrencyAmountController : ControllerBase
    {
        private readonly ICurrencyBlockChainContext _ctx;

        public CryptoCurrencyAmountController(
    ICurrencyBlockChainContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست قیمت برای رمز ارز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_CurrencyAmount(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت مقدار رمز ارز مورد نیاز باتوجه به مبلغ تومانی فاکتور - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetByOrder([FromBody] Get_CurrencyPriceByOrder.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_CurrencyPriceByOrder(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت قیمت برای رمز ارز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CurrencyAmount(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
