﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.HistoryDeposit;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountInformation;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Cryptocurrency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CryptoCurrencyController : ControllerBase
    {
        private readonly ICurrencyBlockChainContext _ctx;

        public CryptoCurrencyController(
    ICurrencyBlockChainContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست رمز ارز ها - سمت ادمین و مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] Get_Currency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Currency(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست رمز ارز بصورت یکتا - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetByCustomer([FromBody] Get_CurrencyByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_CurrencyByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت رمز ارز جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Currency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Currency(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی رمز ارز ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Currency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Currency(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف رمز ارز ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Currency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Currency(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
