﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Network;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.HistoryDeposit;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Cryptocurrency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class HistoryDepositCryptoCurrencyController : ControllerBase
    {
        private readonly IHistoryDepositBlockChainContext _ctx;

        public HistoryDepositCryptoCurrencyController(
    IHistoryDepositBlockChainContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست تاریخچه تراکنش رمز ارز ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_HistoryDeposit.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_HistoryDeposit(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت تراکنش رمز ارز با کد پیگیری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetByPaymentId([FromBody] Get_PaymentHistoryDeposit.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_PaymentHistoryDeposit(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت کد پیگیری تراکنش رمز ارز توسط مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateByPayment([FromBody] Update_HistoryDeposit_HashIdByPaymentId.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_HistoryDeposit_HashIdByPaymentId(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
