﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Wallet;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Network;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Cryptocurrency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class NetworkCryptoCurrencyController : ControllerBase
    {
        private readonly INetworkBlockChainContext _ctx;

        public NetworkCryptoCurrencyController(
    INetworkBlockChainContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست شبکه ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] Get_Network.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Network(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت شبکه ی جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Network.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Network(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی شبکه - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Network.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Network(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف شبکه - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Network.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Network(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
