﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Logic.IServices.IApp.ICryptoCurrency;
using Farakonesh.Logic.Services.App.CryptoCurrency;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Currency;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Nipoto.Creating.Request;
using Farakonesh.Commands.Services;
using System;
using Farakonesh.API.Filters;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.HistoryDeposit;
using Farakonesh.Models.API.Nipoto.Request;
using Microsoft.AspNetCore.Authorization;
using Farakonesh.Commands.Services.BlockChain;
using Farakonesh.Shared.Helpers;

namespace Farakonesh.API.Controllers.App.Cryptocurrency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class NipotoController : ControllerBase
    {
        private readonly INipotoService _nipotoService;

        public NipotoController(
    INipotoService nipotoService)
        {
            _nipotoService = nipotoService;
        }
        /// <summary>
        /// جهت بررسی واریزی رمز ارز
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Check([FromBody] CheckPayCryptoCurrencyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _nipotoService.checkPay(new InfoDepositRequestModel
            {
                currency = command.Currency,
                network = command.Network,
                wallet = command.Wallet,
                status = "done",
                startDate = DateTime.UtcNow.AddMinutes(-5),
                PaymentId = command.PaymentId,
            }, cancellationToken);
            return Ok(new { rst.Data ,CurrentDate= DateTimeHelper.GetLocalTime() });
        }

        [HttpPut]
        public async Task<IActionResult> GetDepositById([FromBody] GetDepositByIdCommand command, CancellationToken cancellationToken)
        {
            var rst = await _nipotoService.checkPayByDeposit(command.DepositId, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetDepositList([FromBody] InfoDepositRequestModel command, CancellationToken cancellationToken)
        {
            var rst = await _nipotoService.getPayByDepositList(command, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetBalance([FromBody] BalanceRequestNipotoModel command, CancellationToken cancellationToken)
        {
            var rst = await _nipotoService.getBalance(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست قیمت های رمز ارز ها - برای جاب
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetMarketByJob([FromQuery] GetMarketListNipotoCommand command, CancellationToken cancellationToken)
        {
            var rst = await _nipotoService.getMarketList(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست کارمزد ها و وضعیت شبکه ی رمز ارز - برای جاب
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
        public async Task<IActionResult> GetFeeByJob([FromQuery] GetMarketListNipotoCommand command, CancellationToken cancellationToken)
        {
            var rst = await _nipotoService.getFeeList(command, cancellationToken);
            return Ok(rst);
        }
    }
}
