﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IBlockChain;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountInformation;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Wallet;
using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Network;

namespace Farakonesh.API.Controllers.App.Cryptocurrency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class WalletCryptoCurrencyController : ControllerBase
    {
        private readonly IWalletBlockChainContext _ctx;

        public WalletCryptoCurrencyController(
    IWalletBlockChainContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست والت ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_Wallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_Wallet(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف والت ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Wallet.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Wallet(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
