﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Farakonesh.Logic.Database;
using Microsoft.AspNetCore.Authorization;
using Farakonesh.Logic.IQueue;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.Log;
using Farakonesh.Shared.Helpers;
using Farakonesh.Logic.ICommonOperations;
using Farakonesh.Models.API.SMS;
using System.Threading;

namespace Farakonesh.API.Controllers.App
{
	/// <summary>
	/// سرویس های کار با تاریخ سرور
	/// </summary>
	[Route("api/[controller]/[action]")]
	[ApiController]
	public class DateTimeController:ControllerBase
	{

        /// <summary>
        /// دریافت تاریخ و ساعت جاری سرور
        /// </summary>
        /// <returns></returns>
        [HttpGet]
        [AllowAnonymous]
		public IActionResult GetDateNow(CancellationToken cancellationToken)
		{
            return Ok(DateTimeHelper.GetLocalTime());
		}
	}
}
