﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.AccountNumber;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc.Infrastructure;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Namotion.Reflection;
using Farakonesh.Commands.Services.Order;

namespace Farakonesh.API.Controllers.App.Order.AccountNumber
{
    /// <summary>
    /// سرویس های مربوط به شماره حساب مالی ، برای سفارش های حساب به حساب
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class AccountNumberController : ControllerBase
    {
        private readonly IAccountNumberContext _accountNumberContext;
        private readonly IAccountNumberService _accountNumberService;
        public AccountNumberController(IAccountNumberContext accountNumberContext, IAccountNumberService accountNumberService)
        {
            _accountNumberContext = accountNumberContext;
            _accountNumberService = accountNumberService;
        }
        /// <summary>
        /// دریافت شماره حساب فعال مربوط به یک سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Get([FromBody] GetAccountNumberCommand command, CancellationToken cancellationToken)
        {
            var rst = await _accountNumberService.GetAccountNumber(command, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> GetByAdmin([FromBody] GetAccountNumberByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _accountNumberContext.GetAccountNumberByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        public async Task<IActionResult> Save([FromBody] InsertAccountNumber.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _accountNumberContext.InsertAccountNumber(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPost]
        public async Task<IActionResult> SaveGroup([FromBody] InsertAccountNumberGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _accountNumberContext.InsertAccountNumberGroup(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> Update([FromBody] UpdateAccountNumber.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _accountNumberContext.UpdateAccountNumber(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        public async Task<IActionResult> UpdateGroup([FromBody] UpdateAccountNumberGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _accountNumberContext.UpdateAccountNumberGroup(inputs, cancellationToken);
            return Ok(rst);
        }

        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_AccountNumber.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _accountNumberContext.Delete_AccountNumber(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
