﻿using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountInformation;
using Farakonesh.Models.Database.StoredProcedures.App.Order.AccountNumber;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.AccountNumber
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class AccountNumberHistoryController : ControllerBase
    {
        private readonly IAccountNumberContext _ctx;
        public AccountNumberHistoryController(IAccountNumberContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست سوابق حساب به حساب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] GetAccountNumberHistory.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetAccountNumberHistory(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
