﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Advertising
{
    /// <summary>
    /// سرویس های کار با تصاویر تبلیغاتی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class AdvertisingController : ControllerBase
    {
        private readonly IAdvertisingContext _ctx;
        private readonly ISettingContext _ctxSetting;
        private readonly RedisService _redisService;
        public AdvertisingController(IAdvertisingContext ctx, ISettingContext ctxSetting, RedisService redisService)
        {
            _ctx = ctx;
            _redisService = redisService;
            _ctxSetting = ctxSetting;
        }
        /// <summary>
        /// دریافت لیست تصاویر تبلیغاتی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetAll([FromBody] GetAdvertisingList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetAdvertisingList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت یک تصویر تبلیغاتی با شناسه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetById([FromBody] GetAdvertisingById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetAdvertisingById(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک تصویر تبلیغاتی جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] InsertAdvertising.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.InsertAdvertising(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی یک تصویر تبلیغاتی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] UpdateAdvertising.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.UpdateAdvertising(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف یک تصویر تبلیغاتی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Advertising.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Advertising(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
