﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.ApplicationFee;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.ApplicationFee
{
    /// <summary>
    /// سرویس های کار با نوع سفارش اپلیکیشن فی - شهریه دانشگاه - شهریه خوابگاه
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderApplicationFeeController : ControllerBase
    {
        private readonly IApplicationFeeContext _applicationFeeContext;
        private readonly ISettingContext _ctxSetting;
        private readonly RedisService _redisService;
        public OrderApplicationFeeController(IApplicationFeeContext applicationFeeContext
            , ISettingContext ctxSetting, RedisService redisService)
        {
            _applicationFeeContext = applicationFeeContext;
            _redisService = redisService;
            _ctxSetting = ctxSetting;

        }
        /// <summary>
        /// دریافت جزئیات سفارش مربوط به اپلیکیشن فی یا شهریه دانشگاه و یا شهریه خوابگاه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_ApplicationFee.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.GetOrder_ApplicationFee(inputs,cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت جزئیات سفارش گروهی اپلیکیشن فی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAllGroup([FromBody] GetOrder_ApplicationFeeMultiple.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.GetOrder_ApplicationFeeMultiple(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت ریز جزئیات سفارش گروهی اپلیکیشن فی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAllGroupDetails([FromBody] GetOrder_ApplicationFeeMultipleDetails.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.GetOrder_ApplicationFeeMultipleDetails(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت جزئیات سفارش اپلیکیشن فی گروهی برای ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllGroupByAdmin([FromBody] GetOrder_ApplicationFeeMultipleByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.GetOrder_ApplicationFeeMultipleByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت جزئیات سفارش مربوط به اپلیکیشن فی یا شهریه دانشگاه و یا شهریه خوابگاه برای ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_ApplicationFeeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.GetOrder_ApplicationFeeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت قیمت آنی سفارش مربوط به اپلیکیشن فی یا شهریه دانشگاه و یا شهریه خوابگاه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderApplicationFee_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.Get_OrderApplicationFee_Price(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش اپلیکیشن فی یا شهریه دانشگاه و یا شهریه خوابگاه در سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderApplicationFeeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.Insert_OrderApplicationFeeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش اپلیکیشن فی یا شهریه دانشگاه و یا شهریه خوابگاه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderApplicationFeeByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.Insert_OrderApplicationFeeByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش اپلیکیشن فی - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderApplicationFeeByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.Insert_OrderApplicationFeeByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش اپلیکیشن فی گروهی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> SaveGroup([FromBody] Insert_OrderApplicationFeeMultipleByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _applicationFeeContext.Insert_OrderApplicationFeeMultipleByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
