﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Authorization;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Models.Database;

namespace Farakonesh.API.Controllers.App.Order.Country
{
    /// <summary>
    /// سرویس های کار با کشور ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CountryController : ControllerBase
    {
        private readonly ICountryContext _ctx;
        private readonly IRedisContextService _redisContextService;

        public CountryController(
ICountryContext ctx, IRedisContextService redisContextService)
        {
            _ctx = ctx;
            _redisContextService = redisContextService;
        }
        /// <summary>
        /// دریافت لیست کشور ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetAll([FromBody] GetCountryList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _redisContextService.GetCountryListAsync(inputs, cancellationToken);
            return Ok(new DBResult() { Data= rst});
        }
        /// <summary>
        /// دریافت یک کشور با استفاده از شناسه آن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetById([FromBody] GetCountryById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCountryById(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت یک کشور جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Country.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Country(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی کشور
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Country.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Country(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف یک کشور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Country.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Country(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
