﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    /// <summary>
    /// سرویس های کار با قیمت ارز ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyAmountController : ControllerBase
    {
        private readonly IOrderContext _ctx;
        private readonly ICurrencyContext _ctxCurrency;
        public CurrencyAmountController(
IOrderContext ctx, ICurrencyContext ctxCurrency)
        {
            _ctx = ctx;
            _ctxCurrency = ctxCurrency;
        }
        /// <summary>
        /// دریافت لیست ارز ها به همراه قیمت روز و نام نمایشی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetCurrencyAmountList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.GetCurrencyAmountList(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// دریافت لیست ارز ها به همراه قیمت روز و نام نمایشی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetCurrencyAmountListByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.GetCurrencyAmountListByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// دریافت یک ارز به همراه قیمت روز و نام نمایشی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetById([FromBody] GetCurrencyAmountById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.GetCurrencyAmountById(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ذخیره یک قیمت جدید برای ارز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Insert_CurrencyAmount(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ذخیره گروهی قیمت
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveGroup([FromBody] Insert_CurrencyAmountGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Insert_CurrencyAmountGroup(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
