﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.dbo;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Servant.Order;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Models.Database;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    /// <summary>
    /// سرویس های کار با ارز ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyController : ControllerBase
    {
        private readonly ICurrencyContext _ctxCurrency;
        private readonly IRedisContextService _redisContextService;

        public CurrencyController(ICurrencyContext ctxCurrency, IRedisContextService redisContextService)
        {
            _ctxCurrency = ctxCurrency;
            _redisContextService = redisContextService;
        }
        /// <summary>
        /// دریافت لیست ارز ها به همراه نام نمایشی آن - جهت دریافت توضیحات بیشتر در مورد نام نمایشی توضیحات مربوط به خود فیلد را بخوانید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetCurrencyList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _redisContextService.GetCurrencyListAsync(inputs, cancellationToken);
            return Ok(new DBResult() { Data = rst });
        }
        /// <summary>
        /// دریافت لیست ارز ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] GetCurrency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.GetCurrency(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست ارز ها به همراه قیمت روز آن و نام نمایشی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetReadyCurrency([FromBody] GetCurrencyAmountListByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.GetCurrencyAmountListByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }

     

        /// <summary>
        /// دریافت یک ارز با شناسه ی آن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetById([FromBody] GetCurrencyById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.GetCurrencyById(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت یک ارز جدید در سیستم به همراه انتصصاب به یک سفارش - در استفاده از این سرویس خیلی دقت کنید ، افزودن بی رویه ارز های نامعتبر می تواند کارکرد سیستم را دچار اشکال کند
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Currency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Insert_Currency(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت سوابق قیمت های ارز های شاخص با تطبیق بر اساس تاریخ سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveIndicator([FromBody] Insert_CurrencyIndicator_Automatic.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Insert_CurrencyIndicator_Automatic(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// انتصاب گروهی ارز به یک نوع سفارش - در استفاده از این سرویس خیلی دقت کنید ، انتصاب های بی رویه می تواند کارکرد سیستم را دچار اشکال کند
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveMainGroup([FromBody] Insert_Currency_Main.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Insert_Currency_Main(inputs, cancellationToken);
            return Ok(rst);
        }

     

        /// <summary>
        /// بروز رسانی اطلاعات ارز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Currency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Update_Currency(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی نام نمایشی ارز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateShow([FromBody] Update_CurrencyShow.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Update_CurrencyShow(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن حداقل آستانه تغییر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateMinAmountForChange([FromBody] Update_MinAmountForChange.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Update_MinAmountForChange(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// بروز رسانی درصد تاثیر پذیری در قیمت روز ارز هنگام استخراج برای یک نوع سفارش خاص
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdatePercentageOfImpact([FromBody] Update_CurrencyPercentageOfImpact.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Update_CurrencyPercentageOfImpact(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف یک ارز - در استفاده از این سرویس خیلی دقت کنید زیرا می تواند باعث اشکال در کارکرد سیستم شود ، فقط ارز هایی را حذف کنید که در هیچ سیستمی کاربرد ندارد
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Currency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Delete_Currency(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
