﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyHistoryWarehouseController : ControllerBase
    {
        private readonly ICurrencyHistoryWarehouseContext _ctx;
        private readonly IConfiguration _configuration;
        private readonly IHttpContextAccessor _IHttpContextAccessor;
        public CurrencyHistoryWarehouseController(ICurrencyHistoryWarehouseContext ctx
            , IHttpContextAccessor iHttpContextAccessor,
IConfiguration configuration)
        {
            _ctx = ctx;
            _IHttpContextAccessor = iHttpContextAccessor;
            _configuration = configuration;
        }
        /// <summary>
        /// دریافت لیست سوابق خرید و  فروش انبار ارز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_HistoryWarehouse_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_HistoryWarehouse_Admin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن سابقه ی خرید و فروش سابقه ی انبار ارز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_HistoryWarehouseByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_HistoryWarehouseByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن سابقه ی خرید و فروش انبار ارز با تغییر وضعیت سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByChangeStatusOrder([FromBody] Insert_HistoryWarehouseByChangeStatusOrder.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_HistoryWarehouseByChangeStatusOrder(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPut]
        public async Task<IActionResult> Appointment([FromBody] Appointment_Order_To_CurrencyWareHouse.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Appointment_Order_To_CurrencyWareHouse(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// افزودن سابقه ی خرید و فروش انبار ارز - از سمت سرویس ورکر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> SaveServiceWorker([FromBody] Insert_HistoryWarehouseByServicecWorker.Inputs inputs, CancellationToken cancellationToken)
        {
            if (_IHttpContextAccessor.HttpContext.Connection.RemoteIpAddress.ToString() != _configuration.GetSection("IpServiceWorker").Get<string>())
            {
                throw new InternalServiceException("خطای آی پی");
            }
            var rst = await _ctx.Insert_HistoryWarehouseByServicecWorker(inputs, cancellationToken);
            return Ok(rst);
        }
      
        /// <summary>
        /// حذف سابقه ی خرید و فروش انبار ارز - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_HistoryWarehouse.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_HistoryWarehouse(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
