﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Farakonesh.Shared.Exceptions;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.API.Filters;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyHistoryWarehouseTomanController : ControllerBase
    {
        private readonly ICurrencyHistoryWarehouseTomanContext _ctx;
        private readonly IConfiguration _configuration;
        private readonly IHttpContextAccessor _IHttpContextAccessor;
        public CurrencyHistoryWarehouseTomanController(ICurrencyHistoryWarehouseTomanContext ctx
            , IHttpContextAccessor iHttpContextAccessor,
IConfiguration configuration)
        {
            _ctx = ctx;
            _IHttpContextAccessor = iHttpContextAccessor;
            _configuration = configuration;
        }
        /// <summary>
        /// دریافت لیست سوابق واریز و برداشت انبار تومانی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_HistoryWarehouseToman_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_HistoryWarehouseToman_Admin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن سابقه ی واریز و برداشت سابقه ی انبار تومانی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_HistoryWarehouseTomanByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_HistoryWarehouseTomanByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن سابقه ی واریز و برداشت انبار تومانی با تغییر وضعیت سفارش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByChangeStatusOrder([FromBody] Insert_HistoryWarehouseByChangeStatusOrderToman.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_HistoryWarehouseByChangeStatusOrderToman(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// افزودن سابقه ی خرید و فروش انبار تومانی - از سمت سرویس ورکر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        [CheckServiceKey]
        public async Task<IActionResult> SaveServiceWorker([FromBody] Insert_HistoryWarehouseTomanByServicecWorker.Inputs inputs, CancellationToken cancellationToken)
        {
            if (_IHttpContextAccessor.HttpContext.Connection.RemoteIpAddress.ToString() != _configuration.GetSection("IpServiceWorker").Get<string>())
            {
                throw new InternalServiceException("خطای آی پی");
            }
            var rst = await _ctx.Insert_HistoryWarehouseTomanByServicecWorker(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف سابقه ی واریز و برداشت انبار تومانی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_HistoryWarehouseToman.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_HistoryWarehouseToman(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
