﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    /// <summary>
    /// سرویس های کار با انتصابات ارز و سفارش 
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyOrderController : ControllerBase
    {

        private readonly IOrderContext _ctx;
        private readonly ICurrencyContext _ctxCurrency;

        public CurrencyOrderController(
IOrderContext ctx, ICurrencyContext ctxCurrency)
        {
            _ctx = ctx;
            _ctxCurrency = ctxCurrency;
        }
        /// <summary>
        /// انتصاب یک سفارش به ارز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Appointment_Currency.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Appointment_Currency(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف انتصاب ارز از سفارش - خیلی در استفاده از این سرویس دقت کنید ، حذف بی مورد ممکن است باعث اشکال در کارکرد سیستم شود
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_CurrencyOrder.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Delete_CurrencyOrder(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
