﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    /// <summary>
    /// کار با سرویس تنظیمات ارز ها و کارمزد ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyPercentSettingController : ControllerBase
    {
        private readonly IOrderContext _ctx;
        private readonly ICurrencyContext _ctxCurrency;
        public CurrencyPercentSettingController(
IOrderContext ctx, ICurrencyContext ctxCurrency)
        {
            _ctx = ctx;
            _ctxCurrency = ctxCurrency;
        }
        /// <summary>
        /// دریافت تنظیمات ارز و کارمزد
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_CurrencyPecentSetting.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Get_CurrencyPecentSetting(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت تنظیم ارز و کارمزد جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_CurrencyPercentSetting.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Insert_CurrencyPercentSetting(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی تنظیم ارز و کارمزد
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_CurrencyPercentSetting.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Update_CurrencyPercentSetting(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف تنظیمات ارز و کارمزد - خیلی در استفاده از این سرویس دقت کنید ، در صورتی که حذف بی مورد اتفاق بی افتد می تواند با عث اشکال در کارکرد سیستم شود
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_CurrencyPecentSetting.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxCurrency.Delete_CurrencyPecentSetting(inputs, cancellationToken);
            return Ok(rst);
        }


    }
}
