﻿using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wage;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    /// <summary>
    /// سرویس های کار با کارمزد های متغیر
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyWageController : ControllerBase
    {
        private readonly ICurrencyWageContext _ctx;

        public CurrencyWageController(
ICurrencyWageContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت کارمزد متغیر ارز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetCurrencyWageList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetCurrencyWageList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت کارمزد متغیر جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_CurrencyWage.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CurrencyWage(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت گروهی کارمزد متغیر برای همه ی ارز ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveGroup([FromBody] Insert_CurrencyWageGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CurrencyWageGroup(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت گروهی چند نوع سفارش - چند نوع ارز - چند نوع سیستم
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveFullGroup([FromBody] Insert_CurrencyWage_FullGroupSave.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CurrencyWage_FullGroupSave(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت گروهی کارمزد متغییر برای همه ی ارز ها بصورت پله ای
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveGroupStair([FromBody] Insert_CurrencyWageGroupStair.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CurrencyWageGroupStair(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی کارمزد متغیر ارز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_CurrencyWage.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_CurrencyWage(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی گروهی کارمزد متغیر ارز
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateGroup([FromBody] Update_CurrencyWageGroup.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_CurrencyWageGroup(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف کارمزد متغییر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_CurrencyWage.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_CurrencyWage(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
