﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyWarehouseController : ControllerBase
    {
        private readonly ICurrencyWarehouseContext _ctx;
       
        public CurrencyWarehouseController(ICurrencyWarehouseContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست بسته های ارز انبار - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_CurrencyWarehouse_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_CurrencyWarehouse_Admin(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت بسته ی ارزی جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_CurrencyWarehouseByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CurrencyWarehouseByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
       
        /// <summary>
        /// بروز رسانی ارزی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_CurrencyWarehouseByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_CurrencyWarehouseByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تبدیل ارز از بسته ی ارز به بسته ی ارزی دیگر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Conversion([FromBody] Conversion_CurrencyWarehouseByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Conversion_CurrencyWarehouseByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تبدیل ارز به تومان و یا برعکس - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> ConversionToToman([FromBody] Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Conversion_CurrencyWarehouse_To_CurrencyWarehouseToman_ByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف بسته ی ارزی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_CurrencyWarehouse.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_CurrencyWarehouse(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// پاک سازی کامل انبار های ارزی
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Clear([FromQuery] Clear_CurrencyWarehouse.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Clear_CurrencyWarehouse(inputs, cancellationToken);
            return Ok(rst);
        }
        [HttpPut]
        public async Task<IActionResult> Search([FromBody] Get_CurrencyWarehouse_Search.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_CurrencyWarehouse_Search(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
