﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class CurrencyWarehouseTomanController : ControllerBase
    {
        private readonly ICurrencyWarehouseTomanContext _ctx;

        public CurrencyWarehouseTomanController(ICurrencyWarehouseTomanContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست بسته های تومانی انبار - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_CurrencyWarehouseToman_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_CurrencyWarehouseToman_Admin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت بسته ی تومانی جدید - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_CurrencyWarehouseTomanByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_CurrencyWarehouseTomanByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// بروز رسانی تومانی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_CurrencyWarehouseTomanByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_CurrencyWarehouseTomanByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حساب به حساب - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Conversion([FromBody] Conversion_CurrencyWarehouseTomanByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Conversion_CurrencyWarehouseTomanByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف بسته ی تومانی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_CurrencyWarehouseToman.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_CurrencyWarehouseToman(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// پاک سازی کامل انبار های تومانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Clear([FromQuery] Clear_CurrencyWarehouseToman.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Clear_CurrencyWarehouseToman(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
