﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Currency
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class WagesController : ControllerBase
    {
        private readonly ICurrencyWageContext _ctx;
        public WagesController(
ICurrencyWageContext ctx)
        {
            _ctx = ctx;

        }
        /// <summary>
        /// دریافت لیست کارمزد های ثابت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetWagesList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetWagesList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت کارمزد ثابت برای ارز
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Wages.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Wages(inputs, cancellationToken);
            return Ok(rst);
        }

    }
}
