﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.GiftCard
{
    /// <summary>
    /// سرویس های کار با گیفت کارت های آماده فروش یا همان مخزن گیفت کارت
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class GiftCardController : ControllerBase
    {
        private readonly IGiftCardContext _ctx;

        public GiftCardController(
IGiftCardContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست کامل گیفت کارت های آماده فروش در سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] Get_GiftCardReadySale_Admin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_GiftCardReadySale_Admin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت گیفت کارت آماده فروش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_GiftCardReady.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_GiftCardReady(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی گیفت کارت آماده فروش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_GiftCardReady.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_GiftCardReady(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف گیفت کارت آماده فروش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_GiftCardReady.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_GiftCardReady(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
