﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.GiftCard
{
    /// <summary>
    /// سرویس های کار با نوع گیفت کارت
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class GiftCardTypeController : ControllerBase
    {
        private readonly IGiftCardContext _ctx;

        public GiftCardTypeController(IGiftCardContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست نوع گیفت کارت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetGiftCardTypeList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetGiftCardTypeList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست نوع گیفت کارت با توجه به کشور 
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAllCountry([FromBody] GetGiftCardTypeCountryList.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetGiftCardTypeCountryList(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست نوع گیفت کارت سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetGiftCardTypeListByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetGiftCardTypeListByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت یک نوع گیفت کارت با شناسه آن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetById([FromBody] GetGiftCardTypeById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetGiftCardTypeById(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت نوع گیفت کارت جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] InsertGiftCardType.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.InsertGiftCardType(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی نوع گیفت کارت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] UpdateGiftCardType.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.UpdateGiftCardType(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف نوع گیفت کارت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_GiftCardType.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_GiftCardType(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
