﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.Services.App.Payeer;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.Order.IncomeCashExchange;
using System.Threading;

namespace Farakonesh.API.Controllers.App.Order.IncomeCashExchange
{
    /// <summary>
    /// سرویس های کار با سفارش نقد کردن درآمد ارزی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class IncomeCashExchangeController : ControllerBase
    {
        private readonly IIncomeCashExchangeContext _ctx;
        private readonly RedisService _redisService;
        public IncomeCashExchangeController(
IIncomeCashExchangeContext ctx, RedisService redisService)
        {
            _ctx = ctx;
            _redisService = redisService;
        }
      
        /// <summary>
        /// دریافت اطلاعات نقد کردن درآمد ارزی - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_IncomeCashExchange.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_IncomeCashExchange(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات نقد کردن درآمد ارزی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_IncomeCashExchangeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_IncomeCashExchangeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }


        /// <summary>
        /// دریافت قیمت نقد کردن درآمد ارزی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderIncomeCashExchange_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderIncomeCashExchange_Price(inputs, cancellationToken);
            return Ok(rst);
        }
    
        /// <summary>
        /// ثبت سفارش نوع نقد کردن درآمد ارزی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderIncomeCashExchangeByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderIncomeCashExchangeByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش نوع نقد کردن درآمد ارزی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderIncomeCashExchangeByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderIncomeCashExchangeByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش نقد کردن درآمد ارزی - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderIncomeCashExchangeByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderIncomeCashExchangeByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
