﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Notes;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Notes
{
    /// <summary>
    /// سرویس های کار با یادداشت ادمین
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class NotesController : ControllerBase
    {
        private readonly INoteContext _ctx;

        public NotesController(
INoteContext ctx)
        {
            _ctx = ctx;
        }
        /// <summary>
        /// دریافت لیست یادداشت ها
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetNotes.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetNotes(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// ثبت یک یادداشت جدید
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_Note.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_Note(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی یادداشت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Note.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Note(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// حذف یادداشت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Note.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Note(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
