﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    /// <summary>
    /// سرویس های مربوط به امور مالی و گزارش مالی
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class FinancialController : ControllerBase
    {
        private readonly IOrderContext _orderContext;
        public FinancialController(IOrderContext orderContext)
        {
            _orderContext = orderContext;
        }
        /// <summary>
        /// دریافت گزارش سود و زیان سفارشات خرید برحسب زمان درخواستی - مثل : روزانه - ماهانه - سالانه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetCompeleteOrders([FromBody] GetOrdersCompeletedAdmin_Financial.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _orderContext.GetOrdersCompeletedAdmin_Financial(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت گزارش سود و زیان سفارشات فروش برحسب زمان درخواستی - مثل : روزانه - ماهانه - سالانه
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetCompeleteOrdersSell([FromBody] GetOrdersCompeletedAdmin_Financial_Sell.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _orderContext.GetOrdersCompeletedAdmin_Financial_Sell(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت گزارش سود و زیان سفارشات خرید برحسب زمان درخواستی و برحسب انبار داده - مثل : روزانه - ماهانه - سالانه
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetCompeleteOrdersByCurrencyWareHouse([FromBody] GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _orderContext.GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// گزارش سود و زیان به تفکیک سفارش 
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetCurrencyWareHouseFinancialByOrder([FromBody] GetCurrencyWareHouse_FinancialByOrder.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _orderContext.GetCurrencyWareHouse_FinancialByOrder(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// گزارش جمع سود و زیان باتفکیک سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetCurrencyWareHouseFinancialByOrderSum([FromBody] GetCurrencyWareHouse_FinancialByOrder_Sum.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _orderContext.GetCurrencyWareHouse_FinancialByOrder_Sum(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
