﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    /// <summary>
    /// سرویس های کار با تاریخچه سفارش ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class HistoryOrderController : ControllerBase
    {
        private readonly IOrderContext _ctx;
        private readonly RedisService _redisService;
        public HistoryOrderController(IOrderContext ctx, RedisService redisService)
        {
            _ctx = ctx;
            _redisService = redisService;
        }
        /// <summary>
        /// دریافت لیست تاریخچه ی تغییرات سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAll([FromBody] GetHistoryOrder.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetHistoryOrder(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
