﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Logic.IServices.IApp.IPPG;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class JibitController : ControllerBase
    {
        private readonly IJibitService _jibitService;
        public JibitController(IJibitService jibitService)
        {

            _jibitService = jibitService;
        }

        [HttpPut]
        public async Task<IActionResult> GetHistory([FromBody] GetPayJibitCommand command, CancellationToken cancellationToken)
        {
            var rst = await _jibitService.GetPayList(command, cancellationToken,false);
            return Ok(rst);
        }
    }
}
