﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.App.Order;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    /// <summary>
    /// سرویس های کار با سفارش ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderController : ControllerBase
    {
        private readonly IOrderContext _ctx;
        private readonly IOrderService _orderService;
        private readonly IAlarmOrderService _alarmOrderService;
        public OrderController(IOrderContext ctx,
            IOrderService orderService, IAlarmOrderService alarmOrderService)
        {
            _ctx = ctx;
            _orderService = orderService;
            _alarmOrderService = alarmOrderService;
        }
        /// <summary>
        /// بروز رسانی وضعیت سفارش - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateStatus([FromBody] UpdateStatusCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.updateStatus(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// شارژ کیف پول شرکت های همکار
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> SendCommission([FromBody] UpdateByCommissionCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.updateByCommission(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// نمایش مقدار سود شرکت
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> ShowCommission([FromBody] Show_Order_Company_Commission.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Show_Order_Company_Commission(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// کنسل کردن سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateStatusCancel([FromBody] Update_Order_Status.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Order_Status_Cancel(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// کنسل کردن سفارش بخاطر اتمام زمان اعتبار پرداخت
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateStatusCancelExpireDate([FromBody] Update_Order_Status_ExpireDate_Cancel.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Order_Status_ExpireDate_Cancel(inputs, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// تغییر وضعیت سفارش به درحال بررسی سند واریزی
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateStatusDocument([FromBody] UpdateStatusByCustomerCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.UpdateStatusDocumentByCustomer(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تغییر وضعیت سفارش به در انتظار تماس کارشناسان
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateStatusWaiting([FromBody] UpdateStatusByCustomerCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.updateStatusWaitingByCustomer(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تغییر وضعیت سفارش به در انتظار تعیین وقت توسط کارشناسان
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> UpdateStatusSetAppointment([FromBody] UpdateStatusByCustomerCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.updateStatusSetAppointmentByCustomer(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی اطلاعات مالی سفارش - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> UpdateFinance([FromBody] Update_Order_Finance.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Order_Finance(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی بخشی از اطلاعات سفارش - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_Order.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Update_Order(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست سفارش های کاربر - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrders.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrders(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// مدل خروجی سرویس کامباین ریزالت هست - شامل: لیست ارز ها , سوالات متداول , وضعیت های سفارش گیری , مقادیر ثابت , تنظیمات
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetFull([FromBody] GetFullOrder.Inputs command, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetFullOrder(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// دریافت لیست وضعیت های موجود برای یک سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetStatus([FromBody] GetStatus_Step_Order.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetStatus_Step_Order(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات یک سفارش با شناسه آن
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetById([FromBody] GetOrderById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrderById(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات سفارش جهت چاپ فاکتور
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Print([FromBody] GetOrderById_Print.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrderById_Print(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست سفارش های نا تمام و در جریان - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrdersAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrdersAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست سفارش های نا تمام و در جریان برای خروجی فایل - سمت ادمین 
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdminPrint([FromBody] GetOrdersAdmin_Export.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrdersAdmin_Export(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست سفارش های تکمیل شده - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdminCompeleted([FromBody] GetOrdersCompeletedAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrdersCompeletedAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست سفارش های تکمیل شده برای خروجی فایل - سمت راهبر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdminCompeletedPrint([FromBody] GetOrdersCompeletedAdmin_Export.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrdersCompeletedAdmin_Export(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات یک سفارش با شناسه ی آن - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByIdByAdmin([FromBody] GetOrdersAdminById.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrdersAdminById(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت رسید برای سفارش - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Receipt([FromBody] SaveReceiptCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.saveReceipt(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف یک سفارش - در استفاده از این سرویس خیلی دقت داشته باشید ، زیرا عملا حذف فاکتور اشتباه هست - به درخواست مدیریت این مورد ایجاد گردیده است
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_Order.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Delete_Order(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ارسال ایمیل و پیامک اطلاع رسانی سفارش
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> SendAlarmOrder([FromBody] AlarmOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _alarmOrderService.sendAlarmOrder(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ارسال ایمیل و پیامک لینک پرداخت سفارش
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> SendLinkOrder([FromBody] AlarmOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _alarmOrderService.sendLinkOrder(command, cancellationToken);
            return Ok(rst);
        }

        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Search([FromBody] GetOrders_Search.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrders_Search(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
