﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.API.Filters;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    /// <summary>
    /// سرویس های کار با اسناد واریزی مشتری ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderDocumentsController : ControllerBase
    {
        private readonly IOrderContext _ctx;
        private readonly ISettingContext _ctxSetting;
        private readonly RedisService _redisService;
        public OrderDocumentsController(IOrderContext ctx, ISettingContext ctxSetting, RedisService redisService)
        {
            _ctx = ctx;
            _redisService = redisService;
            _ctxSetting = ctxSetting;
        }
        /// <summary>
        /// ثبت یک سند واریزی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderDocumentsByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderDocumentsByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت سند واریزی یک سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetOrderDocument([FromBody] GetOrderDocuments.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrderDocuments(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت سند واریزی یک سفارش سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        /// 
        [HttpPut]
        public async Task<IActionResult> GetOrderDocumentByAdmin([FromBody] GetOrderDocumentsAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrderDocumentsAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
    }
}
