﻿using Farakonesh.Commands.Services;
using Farakonesh.Logic.IServices.IApp.IPPG;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class SepalController : ControllerBase
    {
        private readonly ISepalService _sepalService;
        public SepalController(ISepalService sepalService)
        {

            _sepalService = sepalService;
        }
        /// <summary>
        /// دریافت لیست سوابق تراکنش های سپال - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetHistory([FromBody] GetPayJibitCommand command, CancellationToken cancellationToken)
        {
            var rst = await _sepalService.GetPayReport(command, cancellationToken);
            return Ok(rst);
        }
    }
}
