﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Commands.Services;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Logic.IServices.IApp.IPPG;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ShepaController : ControllerBase
    {
        private readonly IShepaService _shepaService;
        public ShepaController(IShepaService shepaService)
        {

            _shepaService = shepaService;
        }

        [HttpPut]
        public async Task<IActionResult> GetHistory([FromBody] GetPayShepaCommand command, CancellationToken cancellationToken)
        {
            var rst = await _shepaService.getPay(command, cancellationToken, false);
            return Ok(rst);
        }
    }
}
