﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Newtonsoft.Json;
using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Database;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.IServices.IApp.ICryptoCurrency;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.Log;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.App.PPG;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Transaction;
using System.IO;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.IServices.IApp.IPPG;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    /// <summary>
    /// سرویس های کار با تراکنش ها
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class TransactionsController : ControllerBase
    {
        private readonly IOrderContext _ctx;
        private readonly ITransActionContext _ctxTransActionContext;
        private readonly IOrderService _orderService;
        private readonly IJibitService _jibitService;
        private readonly IZarinpalService _zarinpalService;
        private readonly IZarinLinkService _zarinLinkService;
        private readonly IShepaService _shepaService;
        private readonly ISepalService _sepalService;
        private readonly IVandarService _vandarService;
        private readonly IOrderServicesWallet _orderServicesWallet;
        private readonly IAutoVerifyService _autoVerifyService;
        private readonly INipotoService _nipotoService;
        public TransactionsController(
        IOrderContext ctx, ITransActionContext ctxTransActionContext,
        IOrderService orderService, IJibitService jibitService, IZarinpalService zarinpalService,
        IShepaService shepaService, IVandarService vandarService, IOrderServicesWallet orderServicesWallet,
        IAutoVerifyService autoVerifyService, INipotoService nipotoService, IZarinLinkService zarinLinkService, ISepalService sepalService)
        {
            _ctx = ctx;
            _ctxTransActionContext = ctxTransActionContext;
            _orderService = orderService;
            _zarinpalService = zarinpalService;
            _jibitService = jibitService;
            _shepaService = shepaService;
            _vandarService = vandarService;
            _orderServicesWallet = orderServicesWallet;
            _autoVerifyService = autoVerifyService;
            _nipotoService = nipotoService;
            _zarinLinkService = zarinLinkService;
            _sepalService = sepalService;
        }
        /// <summary>
        /// دریافت لیست تراکنش ها - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetTransActions.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxTransActionContext.GetTransActions(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست تراکنش ها - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetTransActionsByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxTransActionContext.GetTransActionsByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت تراکنش بصورت دستی - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> InsertByAdmin([FromBody] Insert_TransactionByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxTransActionContext.Insert_TransactionByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// شروع یک تراکنش - برای درگاه پرداخت جیبیت - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Insertjb([FromBody] StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _jibitService.startPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// شروع یک تراکنش - برای شارژ کیف پول - برای درگاه پرداخت جیبیت - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertWalletjb([FromBody] StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            var rst = await _jibitService.startPayChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// شروع یک تراکنش - برای درگاه پرداخت زرین پال - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Insertzp([FromBody] StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinpalService.startPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// شروع یک تراکنش - برای شارژ کیف پول - برای درگاه پرداخت زرین پال - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertWalletzp([FromBody] StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinpalService.startPayChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// شروع یک تراکنش - برای درگاه پرداخت زرین لینک - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Insertzl([FromBody] StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.startPay(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// شروع یک تراکنش - برای شارژ کیف پول - برای درگاه پرداخت زرین لینک - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertWalletzl([FromBody] StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.startPayChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت تراکنش برای سفارش رایگان
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertFree([FromBody] UpdateFreeOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.updateFreeOrder(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// پرداخت با کیف پول - درصورتی که شارژ کافی در کیف پول کاربر موجود باشد این گزینه عمل خواهد کرد
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertWallet([FromBody] StartPayWithWalletCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderServicesWallet.startPayWithWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای تراکنش - درگاه پرداخت جیبیت - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Updatejb([FromBody] VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _jibitService.verifyPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای تراکنش - درگاه پرداخت زرین پال - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Updatezp([FromBody] VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinpalService.verifyPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای تراکنش - درگاه پرداخت زرین لینک - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Updatezl([FromBody] VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.verifyPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات پرداخت از درگاه جیبیت - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Getjb([FromBody] GetPayJibitCommand command, CancellationToken cancellationToken)
        {
            var rst = await _jibitService.getPay(command, cancellationToken, true);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات پرداخت از درگاه سپال - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Getsp([FromBody] GetPayJibitCommand command, CancellationToken cancellationToken)
        {
            var rst = await _sepalService.GetPay(command, cancellationToken, true);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای تراکنش برای درگاه پرداخت جیبیت - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> UpdateWalletjb([FromBody] VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {
            var rst = await _jibitService.verifyChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای تراکنش برای درگاه پرداخت زرین پال - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> UpdateWalletzp([FromBody] VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinpalService.verifyChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای تراکنش برای درگاه پرداخت زرین لینک - سمت مشتری
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> UpdateWalletzl([FromBody] VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.verifyChargeWallet(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// دریافت تراکنش های وریفای نشده ولی پرداخت شده از درگاه زرین پال - سمت ادمین
        /// </summary>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetUnverifiedzp([FromBody] GetUnverifiedPayZarinpalCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinpalService.getUnverifiedPay(command, cancellationToken, true);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت تراکنش های وریفای نشده زرین لینک - سمت جاب
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Getzl([FromBody] GetPayShepaCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.getPay(command, cancellationToken, true);
            return Ok(rst);
        }

        /// <summary>
        /// ایجاد یک تراکنش جدید - مخصوص درگاه وندار
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Insertvn([FromBody] StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _vandarService.startPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ایجاد یک تراکنش جدید برای شارژ کیف پول - مخصوص درگاه وندار
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertWalletvn([FromBody] StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            var rst = await _vandarService.startPayChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای سفارش - مخصوص درگاه وندار
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Updatevn([FromBody] VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _vandarService.verifyPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای سفارش شارژ کیف پول - مخصوص درگاه وندار
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> UpdateWalletvn([FromBody] VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {
            var rst = await _vandarService.verifyChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ایجاد یک تراکنش جدید - مخصوص درگاه شپا
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Insertsh([FromBody] StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _shepaService.startPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ایجاد یک تراکنش جدید برای شارژ کیف پول - مخصوص درگاه شپا
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertWalletsh([FromBody] StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            var rst = await _shepaService.startPayChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تکمیل و وریفای سفارش - مخصوص درگاه شپا
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Updatesh([FromBody] VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _shepaService.verifyPay(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// تکمیل و وریفای سفارش شارژ کیف پول - مخصوص شپا
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> UpdateWalletsh([FromBody] VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {
            var rst = await _shepaService.verifyChargeWallet(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات تراکنش - مخصوص درگاه پرداخت شپا
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Getsh([FromBody] GetPayShepaCommand command, CancellationToken cancellationToken)
        {
            var rst = await _shepaService.getPay(command, cancellationToken, true);
            return Ok(rst);
        }
        /// <summary>
        /// ایجاد یک تراکنش جدید - مخصوص درگاه سپال
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Insertsp([FromBody] StartPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _sepalService.StartPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ایجاد یک تراکنش جدید کیف پول - مخصوص درگاه سپال
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertWalletsp([FromBody] StartPayChargeWalletCommand command, CancellationToken cancellationToken)
        {
            var rst = await _sepalService.StartPayChargeWallet(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// تکمیل و وریفای سفارش - مخصوص درگاه سپال
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Updatesp([FromBody] VerifyPayOrderCommand command, CancellationToken cancellationToken)
        {
            var rst = await _sepalService.VerifyPay(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// تکمیل و وریفای سفارش شارژ کیف پول - مخصوص سپال
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> UpdateWalletsp([FromBody] VerifyPayChargeCommand command, CancellationToken cancellationToken)
        {
            var rst = await _sepalService.VerifyChargeWallet(command, cancellationToken);
            return Ok(rst);
        }

        /// <summary>
        /// دریافت اطلاعات تراکنش - مخصوص درگاه پرداخت وندار
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Getvn([FromBody] GetPayVandarCommand command, CancellationToken cancellationToken)
        {
            var rst = await _vandarService.getPay(command, cancellationToken, true);
            return Ok(rst);
        }
        /// <summary>
        /// تعیین تکلیف وضعیت تراکنش های باز مانده در سیستم
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> AutoVerify([FromBody] VerifyPayDatabaseCommand command, CancellationToken cancellationToken)
        {
            var rst = await _autoVerifyService.verifyPayDatabase(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تعیین تکلیف وضعیت تراکنش های باز مانده در سیستم - توسط ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> VerifyManual([FromBody] InquiryPayByAdminCommand command, CancellationToken cancellationToken)
        {
            var rst = await _autoVerifyService.InquiryPayByAdmin(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تغییر وضعیت سفارش از در انتظار ارسال سند به پیش فاکتور و انتقال به درگاه پرداخت
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> changeStatusPayOrder([FromBody] UpdateStatusStartPayCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.updateStatusStartPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// لینک پرداخت عمومی - برای استفاده در پیامک و ایمیل
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPost]
        [AllowAnonymous]
        public async Task<IActionResult> PaymentLink([FromBody] PaymentLinkCommand command, CancellationToken cancellationToken)
        {
            var rst = await _orderService.paymentLink(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت تراکنش رمز ارز
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> InsertCryptoCurrency([FromBody] StartPayOrderByCryptoCurrencyCommand command, CancellationToken cancellationToken)
        {
            var rst = await _nipotoService.startPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تغییر وضعیت تراکنش - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> ChangeStatus([FromBody] Change_Status_Transaction.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctxTransActionContext.Change_Status_Transaction(inputs, cancellationToken);
            return Ok(rst);
        }


    }
}
