﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Commands.Services;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Logic.IServices.IApp.IPPG;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class VandarController : ControllerBase
    {
        private readonly IVandarService _vandarService;
        public VandarController(IVandarService vandarService)
        {

            _vandarService = vandarService;
        }

        [HttpPut]
        public async Task<IActionResult> GetHistory([FromBody] GetPayVandarCommand command, CancellationToken cancellationToken)
        {
            var rst = await _vandarService.getPay(command, cancellationToken, false);
            return Ok(rst);
        }
    }
}
