﻿using Farakonesh.Commands.Services;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Models.Database.StoredProcedures.App.Order.WeightFee;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class WeightFeeController : ControllerBase
    {
        private readonly IWeightFeeContext _weightFeeContext;
        public WeightFeeController(IWeightFeeContext weightFeeContext)
        {

            _weightFeeContext = weightFeeContext;
        }
        /// <summary>
        /// دریافت لیست کارمزد وزن - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Get([FromBody] Get_WeightFee.Inputs command, CancellationToken cancellationToken)
        {
            var rst = await _weightFeeContext.Get_WeightFee(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت کارمزد وزن - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> Save([FromBody] Insert_WeightFee.Inputs command, CancellationToken cancellationToken)
        {
            var rst = await _weightFeeContext.Insert_WeightFee(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروزرسانی کارمزد وزن - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Update([FromBody] Update_WeightFee.Inputs command, CancellationToken cancellationToken)
        {
            var rst = await _weightFeeContext.Update_WeightFee(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// حذف کارمزد وزن - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpDelete]
        public async Task<IActionResult> Delete([FromQuery] Delete_WeightFee.Inputs command, CancellationToken cancellationToken)
        {
            var rst = await _weightFeeContext.Delete_WeightFee(command, cancellationToken);
            return Ok(rst);
        }


    }
}
