﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Services.App.PPG;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Logic.IServices.IApp.IPPG;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ZarinLinkController : ControllerBase
    {
        private readonly IZarinLinkService _zarinLinkService;
        public ZarinLinkController(IZarinLinkService zarinLinkService)
        {
            _zarinLinkService = zarinLinkService;
        }

        /// <summary>
        /// دریافت لیست سوابق لینک های پرداخت تولید شده در زرین لینک - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetHistory([FromBody] InquiryZarinLinkCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.getZarinLinkHistory(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت جزئیات سابقه پرداخت های تولید شده زرین لینک
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetHistoryDetail([FromBody] GetTransactionDetailsCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.GetTransactionDetails(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست تراکنش های یک سابقه - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetTransactionHistory([FromBody] InquiryZarinLinkTransaction command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.getZarinLinkTransaction(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات حساب بانکی ثبت شده در زرین لینک - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetBankAccount([FromBody] InquiryZarinLinkByIdCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.getBankAccount(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// تغییر دوره تسویه حساب - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> Settlement([FromBody] SettlementZarinLinkSettingCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.settlement(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// استعلام نام صاحب حساب - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> InquiryCardHolder([FromBody] InquiryCardHolderZarinLinkCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.InquiryCardHolder(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت موجودی حساب زرین پال - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetCurrentBalance([FromBody] GetCurrentBalanceCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.GetCurrentBalance(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت درخواست استرداد وجه - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> AddRefund([FromBody] AddRefundZarinLinkCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinLinkService.AddRefund(command, cancellationToken);
            return Ok(rst);
        }
    }
}
