﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.Services.App.PPG;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Logic.IServices.IApp.IPPG;

namespace Farakonesh.API.Controllers.App.Order.Orders
{
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class ZarinpalController : ControllerBase
    {
        private readonly IZarinpalService _zarinpalService;
        public ZarinpalController(IZarinpalService zarinpalService)
        {
            _zarinpalService = zarinpalService;
        }
        /// <summary>
        /// دریافت لیست تراکنش های وریفای نشده ولی پرداخت شده - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetUnverified([FromBody] GetUnverifiedPayZarinpalCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinpalService.getUnverifiedPay(command, cancellationToken, false);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت لیست سوابق پرداخت از طریق زرین پال - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetHistory([FromBody] InquiryZarinpalTransActionCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinpalService.getPay(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت تراکنش های زرین پال با اعمال فیلتر - سمت ادمین
        /// </summary>
        /// <param name="command"></param>
        /// <param name="cancellationToken"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetTransaction([FromBody] InquiryZarinpalTransActionCommand command, CancellationToken cancellationToken)
        {
            var rst = await _zarinpalService.getPayByFilter(command, cancellationToken);
            return Ok(rst);
        }
    }
}
