﻿using Farakonesh.API.Filters;
using Farakonesh.Commands.Services;
using Farakonesh.Logic.CommonOperations;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.IDatabase.IOrder;
using Farakonesh.Logic.IDatabase.IQueue;
using Farakonesh.Logic.IServices.IApp.IOrder;
using Farakonesh.Logic.IServices.ICache;
using Farakonesh.Logic.Services.App;
using Farakonesh.Logic.Services.App.Payeer;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Payeer;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using Farakonesh.Shared.Enums;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading;
using System.Threading.Tasks;
using YamlDotNet.Core;

namespace Farakonesh.API.Controllers.App.Order.Payeer
{
    /// <summary>
    /// سرویس های کار با سفارش فروش پایر
    /// </summary>
    [Route("api/[controller]/[action]")]
    [ApiController]
    public class OrderPayeerSellController : ControllerBase
    {
        private readonly IPayeerContext _ctx;
        private readonly IPayeerService _payeerService;
        private readonly IRedisContextService _redisContextService;
        public OrderPayeerSellController(
IPayeerContext ctx,
IPayeerService payeerService, IRedisContextService redisContextService)
        {
            _ctx = ctx;
            _payeerService = payeerService;
            _redisContextService = redisContextService;
        }
        /// <summary>
        /// دریافت اطلاعات فروش پایر - سمت مشتری - بدون نیاز به امضای کاربری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> GetAllAnonymous([FromBody] GetOrder_PayeerSellAnonymous.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PayeerSellAnonymous(inputs, cancellationToken);
            var webServiceInfo = await _redisContextService.GetWebserviceAsync(WebServiceType.Payeer, cancellationToken);
            var config = webServiceInfo.AdditionalConfig.JsonParse();
            return Ok(new DBResult(new { MerchantIdPayeer = (string)config["shopNumberSell"],
                SecretKeyPayeer = (string)config["apiKeySell"],
                rst.Data.Amount,rst.Data.Mark
             },1));
        }
        /// <summary>
        /// دریافت اطلاعات فروش پایر - سمت مشتری
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetAll([FromBody] GetOrder_PayeerSell.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PayeerSell(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// دریافت اطلاعات فروش پایر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        public async Task<IActionResult> GetAllByAdmin([FromBody] GetOrder_PayeerSellByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.GetOrder_PayeerSellByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }


        /// <summary>
        /// دریافت قیمت سفارش
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> GetPrice([FromBody] Get_OrderPayeerSell_Price.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Get_OrderPayeerSell_Price(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// انتقال دهنده به درگاه پرداخت پایر
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [CustomersAuth]
        public async Task<IActionResult> Redirect([FromBody] GetRedirectSellPayeerCommand command, CancellationToken cancellationToken)
        {
            var rst = await _payeerService.getRedirectSellPayeer(command, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش نوع فروش پایر
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CustomersAuth]
        public async Task<IActionResult> Save([FromBody] Insert_OrderPayeerSellByCustomer.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPayeerSellByCustomer(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش نوع فروش پایر - سمت ادمین
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        public async Task<IActionResult> SaveByAdmin([FromBody] Insert_OrderPayeerSellByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPayeerSellByAdmin(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// ثبت سفارش فروش پایر - سمت کمپانی
        /// </summary>
        /// <param name="inputs"></param>
        /// <returns></returns>
        [HttpPost]
        [CompanyAuth]
        public async Task<IActionResult> SaveByCompany([FromBody] Insert_OrderPayeerSellByCompany.Inputs inputs, CancellationToken cancellationToken)
        {
            var rst = await _ctx.Insert_OrderPayeerSellByCompany(inputs, cancellationToken);
            return Ok(rst);
        }
        /// <summary>
        /// بروز رسانی اطلاعات فروش پایر - سمت مشتری - بعد از فروش اطلاعات بطور اتوماتیک بروز خواهند شد
        /// </summary>
        /// <param name="command"></param>
        /// <returns></returns>
        [HttpPut]
        [AllowAnonymous]
        public async Task<IActionResult> Update([FromBody] UpdateSellPayeerCommand command, CancellationToken cancellationToken)
        {
            var rst = await _payeerService.updateSellPayeer(command, cancellationToken);
            return Ok(rst);
        }


    }
}
